/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import de.redsix.pdfcompare.CompareResult;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;

public class DiskUsingCompareResult
extends CompareResult {
    private Path tempDir;
    private boolean hasImages = false;

    @Override
    protected void addImagesToDocument(PDDocument document) throws IOException {
        ArrayList<Path> paths = new ArrayList<Path>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.tempDir, "image_*");){
            for (Path path : directoryStream) {
                paths.add(path);
            }
        }
        Collections.sort(paths);
        for (Path path : paths) {
            this.addPageToDocument(document, ImageIO.read(path.toFile()));
        }
        this.removeTempDir();
    }

    public void removeTempDir() throws IOException {
        if (Files.exists(this.tempDir, new LinkOption[0]) && Files.isDirectory(this.tempDir, new LinkOption[0])) {
            Files.walkFileTree(this.tempDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    @Override
    public synchronized void addPage(boolean hasDifferences, boolean hasDifferenceInExclusion, int pageIndex, BufferedImage expectedImage, BufferedImage actualImage, BufferedImage diffImage) {
        Objects.requireNonNull(expectedImage, "expectedImage is null");
        Objects.requireNonNull(actualImage, "actualImage is null");
        Objects.requireNonNull(diffImage, "diffImage is null");
        this.hasImages = true;
        this.hasDifferenceInExclusion |= hasDifferenceInExclusion;
        if (hasDifferences) {
            this.isEqual = false;
        }
        this.storeImage(pageIndex, diffImage);
    }

    @Override
    protected boolean hasImages() {
        return this.hasImages;
    }

    private void storeImage(int pageIndex, BufferedImage diffImage) {
        try {
            Path tmpDir = this.getTempDir();
            ImageIO.write((RenderedImage)diffImage, "PNG", tmpDir.resolve(String.format("image_%06d", pageIndex)).toFile());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write image to Temp Dir", e);
        }
    }

    public synchronized Path getTempDir() throws IOException {
        if (this.tempDir == null) {
            this.tempDir = Files.createTempDirectory("PdfCompare", new FileAttribute[0]);
            this.tempDir.toFile().deleteOnExit();
        }
        return this.tempDir;
    }
}

