/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare.ui;

import de.redsix.pdfcompare.CompareResultWithExpectedAndActual;
import de.redsix.pdfcompare.PdfComparator;
import de.redsix.pdfcompare.ui.ImagePanel;
import de.redsix.pdfcompare.ui.ViewModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class Display {
    private ViewModel viewModel;

    public void init() {
        this.viewModel = new ViewModel(new CompareResultWithExpectedAndActual());
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(2);
        BorderLayout borderLayout = new BorderLayout();
        frame.setLayout(borderLayout);
        frame.setMinimumSize(new Dimension(400, 200));
        Rectangle screenBounds = Display.getDefaultScreenBounds();
        frame.setSize(Math.min(screenBounds.width, 1700), Math.min(screenBounds.height, 1000));
        frame.setLocation(screenBounds.x, screenBounds.y);
        JToolBar toolBar = new JToolBar();
        toolBar.setRollover(true);
        toolBar.setFloatable(false);
        frame.add((Component)toolBar, "First");
        final ImagePanel leftPanel = new ImagePanel(this.viewModel.getLeftImage());
        final ImagePanel resultPanel = new ImagePanel(this.viewModel.getDiffImage());
        JScrollPane expectedScrollPane = new JScrollPane(leftPanel);
        expectedScrollPane.setMinimumSize(new Dimension(200, 200));
        JScrollPane actualScrollPane = new JScrollPane(resultPanel);
        actualScrollPane.setMinimumSize(new Dimension(200, 200));
        actualScrollPane.getViewport().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                resultPanel.setViewSize(e.getComponent().getSize());
                super.componentResized(e);
            }
        });
        expectedScrollPane.getVerticalScrollBar().setModel(actualScrollPane.getVerticalScrollBar().getModel());
        expectedScrollPane.getHorizontalScrollBar().setModel(actualScrollPane.getHorizontalScrollBar().getModel());
        expectedScrollPane.getViewport().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                leftPanel.setViewSize(e.getComponent().getSize());
                super.componentResized(e);
            }
        });
        JSplitPane splitPane = new JSplitPane(1, expectedScrollPane, actualScrollPane);
        splitPane.setResizeWeight(0.5);
        splitPane.setDividerLocation(0.5);
        splitPane.setOneTouchExpandable(true);
        frame.add((Component)splitPane, "Center");
        JToggleButton expectedButton = new JToggleButton("Expected");
        Display.addToolBarButton(toolBar, "Open...", event -> {
            JFileChooser fileChooser = new JFileChooser();
            if (fileChooser.showDialog(frame, "Open expected PDF") == 0) {
                File expectedFile = fileChooser.getSelectedFile();
                if (fileChooser.showDialog(frame, "Open actual PDF") == 0) {
                    File actualFile = fileChooser.getSelectedFile();
                    try {
                        frame.setCursor(Cursor.getPredefinedCursor(3));
                        this.viewModel = new ViewModel(new PdfComparator<CompareResultWithExpectedAndActual>(expectedFile, actualFile, new CompareResultWithExpectedAndActual()).compare());
                        leftPanel.setImage(this.viewModel.getLeftImage());
                        resultPanel.setImage(this.viewModel.getDiffImage());
                        frame.setCursor(Cursor.getPredefinedCursor(0));
                        expectedButton.setSelected(true);
                    }
                    catch (IOException ex) {
                        Display.DisplayExceptionDialog(frame, ex);
                    }
                }
            }
        });
        toolBar.addSeparator();
        Display.addToolBarButton(toolBar, "Page -", event -> {
            if (this.viewModel.decreasePage()) {
                leftPanel.setImage(this.viewModel.getLeftImage());
                resultPanel.setImage(this.viewModel.getDiffImage());
            }
        });
        Display.addToolBarButton(toolBar, "Page +", event -> {
            if (this.viewModel.increasePage()) {
                leftPanel.setImage(this.viewModel.getLeftImage());
                resultPanel.setImage(this.viewModel.getDiffImage());
            }
        });
        toolBar.addSeparator();
        JToggleButton pageZoomButton = new JToggleButton("Zoom Page");
        pageZoomButton.setSelected(true);
        pageZoomButton.addActionListener(event -> {
            leftPanel.zoomPage();
            resultPanel.zoomPage();
        });
        Display.addToolBarButton(toolBar, "Zoom -", event -> {
            pageZoomButton.setSelected(false);
            leftPanel.decreaseZoom();
            resultPanel.decreaseZoom();
        });
        Display.addToolBarButton(toolBar, "Zoom +", event -> {
            pageZoomButton.setSelected(false);
            leftPanel.increaseZoom();
            resultPanel.increaseZoom();
        });
        toolBar.add(pageZoomButton);
        Display.addToolBarButton(toolBar, "Zoom 100%", event -> {
            pageZoomButton.setSelected(false);
            leftPanel.zoom100();
            resultPanel.zoom100();
        });
        toolBar.addSeparator();
        Display.addToolBarButton(toolBar, "Center Split", event -> {
            splitPane.setDividerLocation(0.5);
            splitPane.revalidate();
        });
        toolBar.addSeparator();
        ButtonGroup buttonGroup = new ButtonGroup();
        expectedButton.setSelected(true);
        expectedButton.addActionListener(event -> {
            this.viewModel.showExpected();
            leftPanel.setImage(this.viewModel.getLeftImage());
        });
        toolBar.add(expectedButton);
        buttonGroup.add(expectedButton);
        JToggleButton actualButton = new JToggleButton("Actual");
        actualButton.addActionListener(event -> {
            this.viewModel.showActual();
            leftPanel.setImage(this.viewModel.getLeftImage());
        });
        toolBar.add(actualButton);
        buttonGroup.add(actualButton);
        frame.setVisible(true);
    }

    private static void DisplayExceptionDialog(JFrame frame, IOException ex) {
        StringWriter stringWriter = new StringWriter();
        ex.printStackTrace(new PrintWriter(stringWriter));
        JTextArea textArea = new JTextArea("Es ist ein unerwarteter Fehler aufgetreten: " + ex.getMessage() + "\n\n" + stringWriter.toString());
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setPreferredSize(new Dimension(900, 700));
        JOptionPane.showMessageDialog(frame, scrollPane);
    }

    private static void addToolBarButton(JToolBar toolBar, String label, ActionListener actionListener) {
        JButton button = new JButton(label);
        button.addActionListener(actionListener);
        toolBar.add(button);
    }

    private static Rectangle getDefaultScreenBounds() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
    }
}

