/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare.cli;

import de.redsix.pdfcompare.PdfComparator;
import de.redsix.pdfcompare.cli.CliArgumentsParseException;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliArguments {
    private static final Logger LOG = LoggerFactory.getLogger(CliArguments.class);
    private static final int EXPECTED_FILENAME_INDEX = 0;
    private static final int ACTUAL_FILENAME_INDEX = 1;
    private static final int EQUAL_DOCUMENTS_RESULT_VALUE = 0;
    private static final int UNEQUAL_DOCUMENTS_RESULT_VALUE = 1;
    private static final int ERROR_RESULT_VALUE = 2;
    private static final String OUTPUT_OPTION = "o";
    private static final String EXCLUSION_OPTION = "x";
    private static final String HELP_OPTION = "h";
    private static final String EXPECTED_PASSWORD_OPTION = "exppwd";
    private static final String ACTUAL_PASSWORD_OPTION = "actpwd";
    private final Options options = new Options();
    private CommandLine commandLine;

    public CliArguments(String[] args) {
        this.options.addOption(Option.builder((String)HELP_OPTION).argName("help").desc("Displays this text and exit").hasArg(false).longOpt("help").numberOfArgs(0).required(false).build());
        this.options.addOption(Option.builder((String)OUTPUT_OPTION).argName("output").desc("Provide an optional output file for the result").hasArg(true).longOpt("output").numberOfArgs(1).required(false).type(String.class).valueSeparator('=').build());
        this.options.addOption(Option.builder((String)EXCLUSION_OPTION).argName("exclusions").desc("Provide an optional file with exclusions").hasArg(true).longOpt("exclusions").numberOfArgs(1).required(false).type(String.class).valueSeparator('=').build());
        this.options.addOption(Option.builder((String)EXPECTED_PASSWORD_OPTION).argName("expected-password").desc("Provide a password for the expected file").hasArg(true).longOpt("expected-password").numberOfArgs(1).required(false).type(String.class).valueSeparator('=').build());
        this.options.addOption(Option.builder((String)ACTUAL_PASSWORD_OPTION).argName("actual-password").desc("Provide a password for the actual file").hasArg(true).longOpt("actual-password").numberOfArgs(1).required(false).type(String.class).valueSeparator('=').build());
        this.process(args);
    }

    public boolean hasFileArguments() {
        return this.commandLine.getArgList().size() == 2 && this.getExpectedFile().isPresent() && this.getActualFile().isPresent();
    }

    private boolean isHelp() {
        return this.commandLine.hasOption(HELP_OPTION);
    }

    public Optional<String> getExpectedFile() {
        return this.getRemainingArgument(0);
    }

    public Optional<String> getActualFile() {
        return this.getRemainingArgument(1);
    }

    public Optional<String> getExclusionsFile() {
        return Optional.ofNullable(this.commandLine.getOptionValue(EXCLUSION_OPTION));
    }

    public Optional<String> getOutputFile() {
        return Optional.ofNullable(this.commandLine.getOptionValue(OUTPUT_OPTION));
    }

    public Optional<String> getExpectedPassword() {
        return Optional.ofNullable(this.commandLine.getOptionValue(EXPECTED_PASSWORD_OPTION));
    }

    public Optional<String> getActualPassword() {
        return Optional.ofNullable(this.commandLine.getOptionValue(ACTUAL_PASSWORD_OPTION));
    }

    int printHelp() {
        new HelpFormatter().printHelp("java -jar pdfcompare-x.x.x-full.jar [EXPECTED] [ACTUAL]", this.options);
        return 0;
    }

    public int execute() {
        if (this.isHelp()) {
            return this.printHelp();
        }
        if (this.hasFileArguments()) {
            return this.doCompare();
        }
        System.out.println("No files or too many files where passed as arguments\n");
        this.printHelp();
        return 2;
    }

    private int doCompare() {
        try {
            PdfComparator pdfComparator = new PdfComparator(this.getExpectedFile().get(), this.getActualFile().get());
            this.getExclusionsFile().ifPresent(pdfComparator::withIgnore);
            this.getExpectedPassword().ifPresent(pdfComparator::withExpectedPassword);
            this.getActualPassword().ifPresent(pdfComparator::withActualPassword);
            Object compareResult = pdfComparator.compare();
            this.getOutputFile().ifPresent(arg_0 -> compareResult.writeTo(arg_0));
            return compareResult.isEqual() ? 0 : 1;
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage());
            return 2;
        }
    }

    private void process(String[] args) {
        try {
            this.commandLine = new DefaultParser().parse(this.options, args);
        }
        catch (ParseException exception) {
            throw new CliArgumentsParseException((Exception)((Object)exception));
        }
    }

    private Optional<String> getRemainingArgument(int index) {
        if (this.commandLine.getArgList().isEmpty() || this.commandLine.getArgList().size() <= index) {
            return Optional.empty();
        }
        return Optional.of((String)this.commandLine.getArgList().get(index));
    }
}

