/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import de.redsix.pdfcompare.CompareResult;
import de.redsix.pdfcompare.ImageWithDimension;
import de.redsix.pdfcompare.PageArea;
import de.redsix.pdfcompare.PageDiffCalculator;
import de.redsix.pdfcompare.ResultCollector;
import de.redsix.pdfcompare.ThrowingConsumer;
import de.redsix.pdfcompare.env.Environment;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareResultImpl
implements ResultCollector,
CompareResult {
    private static final Logger LOG = LoggerFactory.getLogger(CompareResultImpl.class);
    protected Environment environment;
    protected final Map<Integer, ImageWithDimension> diffImages = new TreeMap<Integer, ImageWithDimension>();
    protected boolean isEqual = true;
    protected boolean hasDifferenceInExclusion = false;
    private boolean expectedOnly;
    private boolean actualOnly;
    private Collection<PageArea> diffAreas = new ArrayList<PageArea>();
    private int pages = 0;

    @Override
    public boolean writeTo(String filename) {
        return this.writeTo((PDDocument doc) -> doc.save(filename + ".pdf"));
    }

    @Override
    public boolean writeTo(OutputStream outputStream) {
        Objects.requireNonNull(outputStream, "OutputStream must not be null");
        boolean result = this.writeTo((PDDocument doc) -> doc.save(outputStream));
        this.silentlyCloseOutputStream(outputStream);
        return result;
    }

    private boolean writeTo(ThrowingConsumer<PDDocument, IOException> saver) {
        if (this.hasImages()) {
            try (PDDocument document = new PDDocument();){
                this.addImagesToDocument(document);
                saver.accept(document);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.isEqual;
    }

    private void silentlyCloseOutputStream(OutputStream outputStream) {
        try {
            outputStream.close();
        }
        catch (IOException e) {
            LOG.info("Could not close OutputStream", (Throwable)e);
        }
    }

    protected synchronized boolean hasImages() {
        return !this.diffImages.isEmpty();
    }

    protected synchronized void addImagesToDocument(PDDocument document) throws IOException {
        this.addImagesToDocument(document, this.diffImages);
    }

    protected synchronized void addImagesToDocument(PDDocument document, Map<Integer, ImageWithDimension> images) throws IOException {
        Iterator<Map.Entry<Integer, ImageWithDimension>> iterator = images.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, ImageWithDimension> entry = iterator.next();
            if (!this.keepImages()) {
                iterator.remove();
            }
            this.addPageToDocument(document, entry.getValue());
        }
    }

    protected void addPageToDocument(PDDocument document, ImageWithDimension image) throws IOException {
        PDPage page = new PDPage(new PDRectangle(image.width, image.height));
        document.addPage(page);
        PDImageXObject imageXObject = LosslessFactory.createFromImage((PDDocument)document, (BufferedImage)image.bufferedImage);
        try (PDPageContentStream contentStream = new PDPageContentStream(document, page);){
            contentStream.drawImage(imageXObject, 0.0f, 0.0f, image.width, image.height);
        }
    }

    protected boolean keepImages() {
        return false;
    }

    @Override
    public synchronized void addPage(PageDiffCalculator diffCalculator, int pageIndex, ImageWithDimension expectedImage, ImageWithDimension actualImage, ImageWithDimension diffImage) {
        Objects.requireNonNull(expectedImage, "expectedImage is null");
        Objects.requireNonNull(actualImage, "actualImage is null");
        Objects.requireNonNull(diffImage, "diffImage is null");
        this.hasDifferenceInExclusion |= diffCalculator.differencesFoundInExclusion();
        if (diffCalculator.differencesFound()) {
            this.isEqual = false;
            this.diffAreas.add(diffCalculator.getDiffArea());
            this.diffImages.put(pageIndex, diffImage);
            ++this.pages;
        } else if (this.environment.addEqualPagesToResult()) {
            this.diffImages.put(pageIndex, diffImage);
            ++this.pages;
        }
    }

    @Override
    public void noPagesFound() {
        this.isEqual = false;
    }

    @Override
    public boolean isEqual() {
        return this.isEqual;
    }

    @Override
    public boolean isNotEqual() {
        return !this.isEqual;
    }

    @Override
    public boolean hasDifferenceInExclusion() {
        return this.hasDifferenceInExclusion;
    }

    @Override
    public boolean hasOnlyExpected() {
        return this.expectedOnly;
    }

    @Override
    public boolean hasOnlyActual() {
        return this.actualOnly;
    }

    @Override
    public boolean hasOnlyOneDoc() {
        return this.expectedOnly || this.actualOnly;
    }

    @Override
    public int getNumberOfPages() {
        return this.pages;
    }

    @Override
    public Collection<PageArea> getDifferences() {
        return this.diffAreas;
    }

    @Override
    public String getDifferencesJson() {
        return "exclusions: [\n" + this.getDifferences().stream().map(PageArea::asJson).collect(Collectors.joining(",\n")) + "\n]";
    }

    public void expectedOnly() {
        this.expectedOnly = true;
    }

    public void actualOnly() {
        this.actualOnly = true;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

