/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import de.redsix.pdfcompare.CompareResult;
import de.redsix.pdfcompare.CompareResultImpl;
import de.redsix.pdfcompare.DiffImage;
import de.redsix.pdfcompare.Exclusions;
import de.redsix.pdfcompare.ImageWithDimension;
import de.redsix.pdfcompare.PageArea;
import de.redsix.pdfcompare.PageDiffCalculator;
import de.redsix.pdfcompare.RenderingException;
import de.redsix.pdfcompare.ResourceCacheWithLimitedImages;
import de.redsix.pdfcompare.ResultCollector;
import de.redsix.pdfcompare.Utilities;
import de.redsix.pdfcompare.env.DefaultEnvironment;
import de.redsix.pdfcompare.env.Environment;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.ResourceCache;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfComparator<T extends CompareResultImpl> {
    private static final Logger LOG = LoggerFactory.getLogger(PdfComparator.class);
    public static final int MARKER_WIDTH = 20;
    private Environment environment;
    private Exclusions exclusions;
    private InputStreamSupplier expectedStreamSupplier;
    private InputStreamSupplier actualStreamSupplier;
    private ExecutorService drawExecutor;
    private ExecutorService parrallelDrawExecutor;
    private ExecutorService diffExecutor;
    private final T compareResult;
    private final int timeout = 3;
    private final TimeUnit unit = TimeUnit.MINUTES;
    private String expectedPassword = "";
    private String actualPassword = "";
    private boolean withIgnoreCalled = false;

    public static <T extends CompareResultImpl> PdfComparator base64(String expectedPdfBase64, String actualPdfBase64) {
        return PdfComparator.base64(expectedPdfBase64, actualPdfBase64, new CompareResultImpl());
    }

    public static <T extends CompareResultImpl> PdfComparator base64(String expectedPdfBase64, String actualPdfBase64, T compareResult) {
        PdfComparator<T> pdfComparator = new PdfComparator<T>(compareResult);
        pdfComparator.expectedStreamSupplier = () -> new ByteArrayInputStream(Base64.getDecoder().decode(expectedPdfBase64));
        pdfComparator.actualStreamSupplier = () -> new ByteArrayInputStream(Base64.getDecoder().decode(actualPdfBase64));
        return pdfComparator;
    }

    private PdfComparator(T compareResult) {
        Objects.requireNonNull(compareResult, "compareResult is null");
        this.compareResult = compareResult;
    }

    public PdfComparator(String expectedPdfFilename, String actualPdfFilename) {
        this(expectedPdfFilename, actualPdfFilename, new CompareResultImpl());
    }

    public PdfComparator(String expectedPdfFilename, String actualPdfFilename, T compareResult) {
        this(compareResult);
        Objects.requireNonNull(expectedPdfFilename, "expectedPdfFilename is null");
        Objects.requireNonNull(actualPdfFilename, "actualPdfFilename is null");
        if (!expectedPdfFilename.equals(actualPdfFilename)) {
            this.expectedStreamSupplier = () -> Files.newInputStream(Paths.get(expectedPdfFilename, new String[0]), new OpenOption[0]);
            this.actualStreamSupplier = () -> Files.newInputStream(Paths.get(actualPdfFilename, new String[0]), new OpenOption[0]);
        }
    }

    public PdfComparator(Path expectedPath, Path actualPath) {
        this(expectedPath, actualPath, new CompareResultImpl());
    }

    public PdfComparator(Path expectedPath, Path actualPath, T compareResult) {
        this(compareResult);
        Objects.requireNonNull(expectedPath, "expectedPath is null");
        Objects.requireNonNull(actualPath, "actualPath is null");
        if (!expectedPath.equals(actualPath)) {
            this.expectedStreamSupplier = () -> Files.newInputStream(expectedPath, new OpenOption[0]);
            this.actualStreamSupplier = () -> Files.newInputStream(actualPath, new OpenOption[0]);
        }
    }

    public PdfComparator(File expectedFile, File actualFile) {
        this(expectedFile, actualFile, new CompareResultImpl());
    }

    public PdfComparator(File expectedFile, File actualFile, T compareResult) {
        this(compareResult);
        Objects.requireNonNull(expectedFile, "expectedFile is null");
        Objects.requireNonNull(actualFile, "actualFile is null");
        if (!expectedFile.equals(actualFile)) {
            this.expectedStreamSupplier = () -> new FileInputStream(expectedFile);
            this.actualStreamSupplier = () -> new FileInputStream(actualFile);
        }
    }

    public PdfComparator(InputStream expectedPdfIS, InputStream actualPdfIS) {
        this(expectedPdfIS, actualPdfIS, new CompareResultImpl());
    }

    public PdfComparator(InputStream expectedPdfIS, InputStream actualPdfIS, T compareResult) {
        this(compareResult);
        Objects.requireNonNull(expectedPdfIS, "expectedPdfIS is null");
        Objects.requireNonNull(actualPdfIS, "actualPdfIS is null");
        if (!expectedPdfIS.equals(actualPdfIS)) {
            this.expectedStreamSupplier = () -> expectedPdfIS;
            this.actualStreamSupplier = () -> actualPdfIS;
        }
    }

    @Deprecated
    public void setEnvironment(Environment environment) {
        this.withEnvironment(environment);
    }

    public PdfComparator<T> withEnvironment(Environment environment) {
        if (this.withIgnoreCalled) {
            throw new IllegalStateException("withEnvironment(...) must be called before any withIgnore(...) methods are called.");
        }
        this.environment = environment;
        return this;
    }

    public PdfComparator<T> withIgnore(String ignoreFilename) {
        Objects.requireNonNull(ignoreFilename, "ignoreFilename is null");
        this.withIgnoreCalled = true;
        this.getExclusions().readExclusions(ignoreFilename);
        return this;
    }

    public PdfComparator<T> withIgnore(File ignoreFile) {
        Objects.requireNonNull(ignoreFile, "ignoreFile is null");
        this.withIgnoreCalled = true;
        this.getExclusions().readExclusions(ignoreFile);
        return this;
    }

    public PdfComparator<T> withIgnore(Path ignorePath) {
        Objects.requireNonNull(ignorePath, "ignorePath is null");
        this.withIgnoreCalled = true;
        this.getExclusions().readExclusions(ignorePath);
        return this;
    }

    public PdfComparator<T> withIgnore(InputStream ignoreIS) {
        Objects.requireNonNull(ignoreIS, "ignoreIS is null");
        this.withIgnoreCalled = true;
        this.getExclusions().readExclusions(ignoreIS);
        return this;
    }

    public PdfComparator<T> withIgnore(PageArea exclusion) {
        Objects.requireNonNull(exclusion, "exclusion is null");
        this.withIgnoreCalled = true;
        this.getExclusions().add(exclusion);
        return this;
    }

    @Deprecated
    public PdfComparator<T> with(PageArea exclusion) {
        return this.withIgnore(exclusion);
    }

    public PdfComparator<T> withExpectedPassword(String password) {
        Objects.requireNonNull(password, "password is null");
        this.expectedPassword = password;
        return this;
    }

    public PdfComparator<T> withActualPassword(String password) {
        Objects.requireNonNull(password, "password is null");
        this.actualPassword = password;
        return this;
    }

    private Exclusions getExclusions() {
        if (this.exclusions == null) {
            this.exclusions = new Exclusions(this.getEnvironment());
        }
        return this.exclusions;
    }

    private Environment getEnvironment() {
        if (this.environment == null) {
            this.environment = DefaultEnvironment.create();
        }
        return this.environment;
    }

    private void buildEnvironment() {
        ((CompareResultImpl)this.compareResult).setEnvironment(this.getEnvironment());
        this.drawExecutor = Utilities.blockingExecutor("Draw", 1, 50, this.environment);
        this.parrallelDrawExecutor = Utilities.blockingExecutor("ParallelDraw", 2, 4, this.environment);
        this.diffExecutor = Utilities.blockingExecutor("Diff", 1, 2, this.environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompareResult compare() throws IOException {
        try {
            if (this.expectedStreamSupplier == null || this.actualStreamSupplier == null) {
                T t = this.compareResult;
                return t;
            }
            this.buildEnvironment();
            try (InputStream expectedStream = this.expectedStreamSupplier.get();){
                try (InputStream actualStream = this.actualStreamSupplier.get();
                     PDDocument expectedDocument = PDDocument.load((InputStream)expectedStream, (String)this.expectedPassword, (MemoryUsageSetting)Utilities.getMemorySettings(this.environment.getDocumentCacheSize()));
                     PDDocument actualDocument = PDDocument.load((InputStream)actualStream, (String)this.actualPassword, (MemoryUsageSetting)Utilities.getMemorySettings(this.environment.getDocumentCacheSize()));){
                    this.compare(expectedDocument, actualDocument);
                }
                catch (NoSuchFileException ex) {
                    this.addSingleDocumentToResult(expectedStream, this.environment.getActualColor().getRGB());
                    ((CompareResultImpl)this.compareResult).expectedOnly();
                }
            }
            catch (NoSuchFileException ex) {
                try (InputStream actualStream = this.actualStreamSupplier.get();){
                    this.addSingleDocumentToResult(actualStream, this.environment.getExpectedColor().getRGB());
                    ((CompareResultImpl)this.compareResult).actualOnly();
                }
                catch (NoSuchFileException innerEx) {
                    LOG.warn("No files found to compare. Tried Expected: '{}' and Actual: '{}'", (Object)ex.getFile(), (Object)innerEx.getFile());
                    ((CompareResultImpl)this.compareResult).noPagesFound();
                }
            }
        }
        finally {
            this.compareResult.done();
        }
        return this.compareResult;
    }

    private void compare(PDDocument expectedDocument, PDDocument actualDocument) throws IOException {
        expectedDocument.setResourceCache((ResourceCache)new ResourceCacheWithLimitedImages(this.environment));
        PDFRenderer expectedPdfRenderer = new PDFRenderer(expectedDocument);
        actualDocument.setResourceCache((ResourceCache)new ResourceCacheWithLimitedImages(this.environment));
        PDFRenderer actualPdfRenderer = new PDFRenderer(actualDocument);
        int minPageCount = Math.min(expectedDocument.getNumberOfPages(), actualDocument.getNumberOfPages());
        CountDownLatch latch = new CountDownLatch(minPageCount);
        for (int pageIndex = 0; pageIndex < minPageCount; ++pageIndex) {
            this.drawImage(latch, pageIndex, expectedDocument, actualDocument, expectedPdfRenderer, actualPdfRenderer);
        }
        Utilities.await(latch, "FullCompare", this.environment);
        Utilities.shutdownAndAwaitTermination(this.drawExecutor, "Draw");
        Utilities.shutdownAndAwaitTermination(this.parrallelDrawExecutor, "Parallel Draw");
        Utilities.shutdownAndAwaitTermination(this.diffExecutor, "Diff");
        if (expectedDocument.getNumberOfPages() > minPageCount) {
            this.addExtraPages(expectedDocument, expectedPdfRenderer, minPageCount, this.environment.getActualColor().getRGB(), true);
        } else if (actualDocument.getNumberOfPages() > minPageCount) {
            this.addExtraPages(actualDocument, actualPdfRenderer, minPageCount, this.environment.getExpectedColor().getRGB(), false);
        }
    }

    private void drawImage(CountDownLatch latch, int pageIndex, PDDocument expectedDocument, PDDocument actualDocument, PDFRenderer expectedPdfRenderer, PDFRenderer actualPdfRenderer) {
        this.drawExecutor.execute(() -> {
            try {
                LOG.trace("Drawing page {}", (Object)pageIndex);
                Future<ImageWithDimension> expectedImageFuture = this.parrallelDrawExecutor.submit(() -> PdfComparator.renderPageAsImage(expectedDocument, expectedPdfRenderer, pageIndex, this.environment));
                Future<ImageWithDimension> actualImageFuture = this.parrallelDrawExecutor.submit(() -> PdfComparator.renderPageAsImage(actualDocument, actualPdfRenderer, pageIndex, this.environment));
                ImageWithDimension expectedImage = this.getImage(expectedImageFuture, pageIndex, "expected document");
                ImageWithDimension actualImage = this.getImage(actualImageFuture, pageIndex, "actual document");
                DiffImage diffImage = new DiffImage(expectedImage, actualImage, pageIndex, this.environment, this.getExclusions(), (ResultCollector)this.compareResult);
                LOG.trace("Enqueueing page {}.", (Object)pageIndex);
                this.diffExecutor.execute(() -> {
                    LOG.trace("Diffing page {}", (Object)diffImage);
                    diffImage.diffImages();
                    LOG.trace("DONE Diffing page {}", (Object)diffImage);
                });
                LOG.trace("DONE drawing page {}", (Object)pageIndex);
            }
            catch (RenderingException renderingException) {
            }
            finally {
                latch.countDown();
            }
        });
    }

    private ImageWithDimension getImage(Future<ImageWithDimension> imageFuture, int pageIndex, String type) {
        try {
            return imageFuture.get(3L, this.unit);
        }
        catch (InterruptedException e) {
            LOG.warn("Waiting for Future was interrupted while rendering page {} for {}", new Object[]{pageIndex, type, e});
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException e) {
            LOG.error("Waiting for Future timed out after {} {} while rendering page {} for {}", new Object[]{3, this.unit, pageIndex, type, e});
        }
        catch (ExecutionException e) {
            LOG.error("Error while rendering page {} for {}", new Object[]{pageIndex, type, e});
        }
        throw new RenderingException();
    }

    private void addSingleDocumentToResult(InputStream expectedPdfIS, int markerColor) throws IOException {
        try (PDDocument expectedDocument = PDDocument.load((InputStream)expectedPdfIS);){
            PDFRenderer expectedPdfRenderer = new PDFRenderer(expectedDocument);
            this.addExtraPages(expectedDocument, expectedPdfRenderer, 0, markerColor, true);
        }
    }

    private void addExtraPages(PDDocument document, PDFRenderer pdfRenderer, int minPageCount, int color, boolean expected) throws IOException {
        for (int pageIndex = minPageCount; pageIndex < document.getNumberOfPages(); ++pageIndex) {
            int i;
            ImageWithDimension image = PdfComparator.renderPageAsImage(document, pdfRenderer, pageIndex, this.environment);
            DataBuffer dataBuffer = image.bufferedImage.getRaster().getDataBuffer();
            for (i = 0; i < image.bufferedImage.getWidth() * 20; ++i) {
                dataBuffer.setElem(i, color);
            }
            for (i = 0; i < image.bufferedImage.getHeight(); ++i) {
                for (int j = 0; j < 20; ++j) {
                    dataBuffer.setElem(i * image.bufferedImage.getWidth() + j, color);
                }
            }
            if (expected) {
                ((CompareResultImpl)this.compareResult).addPage(new PageDiffCalculator(new PageArea(pageIndex + 1)), pageIndex, image, PdfComparator.blank(image), image);
                continue;
            }
            ((CompareResultImpl)this.compareResult).addPage(new PageDiffCalculator(new PageArea(pageIndex + 1)), pageIndex, PdfComparator.blank(image), image, image);
        }
    }

    private static ImageWithDimension blank(ImageWithDimension image) {
        return new ImageWithDimension(new BufferedImage(image.bufferedImage.getWidth(), image.bufferedImage.getHeight(), image.bufferedImage.getType()), image.width, image.height);
    }

    public static ImageWithDimension renderPageAsImage(PDDocument document, PDFRenderer expectedPdfRenderer, int pageIndex, Environment environment) throws IOException {
        BufferedImage bufferedImage = expectedPdfRenderer.renderImageWithDPI(pageIndex, (float)environment.getDPI());
        PDPage page = document.getPage(pageIndex);
        PDRectangle mediaBox = page.getMediaBox();
        if (page.getRotation() == 90 || page.getRotation() == 270) {
            return new ImageWithDimension(bufferedImage, mediaBox.getHeight(), mediaBox.getWidth());
        }
        return new ImageWithDimension(bufferedImage, mediaBox.getWidth(), mediaBox.getHeight());
    }

    public T getResult() {
        return this.compareResult;
    }

    @FunctionalInterface
    private static interface InputStreamSupplier {
        public InputStream get() throws IOException;
    }
}

