/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigSyntax;
import de.redsix.pdfcompare.PageArea;
import de.redsix.pdfcompare.PageExclusions;
import de.redsix.pdfcompare.env.Environment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Exclusions {
    private static final Logger LOG = LoggerFactory.getLogger(Exclusions.class);
    private final int dpi;
    private final float CM_TO_PIXEL;
    private final float MM_TO_PIXEL;
    private final float PT_TO_PIXEL;
    private static final Pattern NUMBER = Pattern.compile("([0-9.]+)(cm|mm|pt)");
    private static final ConfigParseOptions configParseOptions = ConfigParseOptions.defaults().setSyntax(ConfigSyntax.CONF).setAllowMissing(true);
    private final Map<Integer, PageExclusions> exclusionsPerPage = new HashMap<Integer, PageExclusions>();
    private final PageExclusions exclusionsForAllPages = new PageExclusions();

    public Exclusions(Environment environment) {
        this.dpi = environment.getDPI();
        this.CM_TO_PIXEL = 0.39370078f * (float)this.dpi;
        this.MM_TO_PIXEL = this.CM_TO_PIXEL / 10.0f;
        this.PT_TO_PIXEL = (float)this.dpi / 72.0f;
    }

    public Exclusions add(PageArea exclusion) {
        if (exclusion.page < 0) {
            this.exclusionsForAllPages.add(exclusion);
        } else {
            this.exclusionsPerPage.computeIfAbsent(exclusion.page, k -> new PageExclusions(this.exclusionsForAllPages)).add(exclusion);
        }
        return this;
    }

    public PageExclusions forPage(int page) {
        return this.exclusionsPerPage.getOrDefault(page, this.exclusionsForAllPages);
    }

    public void readExclusions(String filename) {
        Objects.requireNonNull(filename, "filename must not be null");
        this.readExclusions(new File(filename));
    }

    public void readExclusions(Path path) {
        Objects.requireNonNull(path, "path must not be null");
        if (Files.exists(path, new LinkOption[0])) {
            this.readExclusions(path.toFile());
        } else {
            LOG.info("Ignore-file at '{}' not found. Continuing without ignores.", (Object)path);
        }
    }

    public void readExclusions(File file) {
        Objects.requireNonNull(file, "file must not be null");
        if (file.exists()) {
            Config exclusionConfig = ConfigFactory.parseFile((File)file, (ConfigParseOptions)configParseOptions);
            this.readFromConfig(exclusionConfig);
        } else {
            LOG.info("Ignore-file at '{}' not found. Continuing without ignores.", (Object)file);
        }
    }

    public void readExclusions(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "inputStream must not be null");
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            this.readExclusions(inputStreamReader);
        }
        catch (IOException e) {
            LOG.warn("Could not read ignores from InputStream. Continuing without ignores.", (Throwable)e);
        }
    }

    public void readExclusions(Reader reader) {
        Objects.requireNonNull(reader, "reader must not be null");
        Config exclusionConfig = ConfigFactory.parseReader((Reader)reader, (ConfigParseOptions)configParseOptions);
        this.readFromConfig(exclusionConfig);
    }

    private void readFromConfig(Config exclusionConfig) {
        List exclusions = exclusionConfig.getObjectList("exclusions");
        exclusions.stream().map(co -> {
            Config c = co.toConfig();
            if (!(c.hasPath("x1") || c.hasPath("y1") || c.hasPath("x2") || c.hasPath("y2"))) {
                return new PageArea(c.getInt("page"));
            }
            if (c.hasPath("page")) {
                return new PageArea(c.getInt("page"), this.toPix(c, "x1"), this.toPix(c, "y1"), this.toPix(c, "x2"), this.toPix(c, "y2"));
            }
            return new PageArea(this.toPix(c, "x1"), this.toPix(c, "y1"), this.toPix(c, "x2"), this.toPix(c, "y2"));
        }).forEach((? super T e) -> this.add((PageArea)e));
    }

    private int toPix(Config c, String key) {
        try {
            return c.getInt(key);
        }
        catch (ConfigException.WrongType e) {
            String valueStr = c.getString(key);
            Matcher matcher = NUMBER.matcher(valueStr);
            if (matcher.matches()) {
                float factor = 0.0f;
                if ("mm".equals(matcher.group(2))) {
                    factor = this.MM_TO_PIXEL;
                } else if ("cm".equals(matcher.group(2))) {
                    factor = this.CM_TO_PIXEL;
                } else if ("pt".equals(matcher.group(2))) {
                    factor = this.PT_TO_PIXEL;
                }
                return Math.round(factor * Float.parseFloat(matcher.group(1)));
            }
            throw new RuntimeException("Exclusion can't be read. String not parsable to a number: " + valueStr);
        }
    }

    public void forEach(Consumer<PageArea> exclusionConsumer) {
        this.exclusionsForAllPages.forEach(exclusionConsumer);
        this.exclusionsPerPage.values().forEach((? super T pe) -> pe.forEach(exclusionConsumer));
    }
}

