/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare.env;

import de.redsix.pdfcompare.env.DefaultEnvironment;
import de.redsix.pdfcompare.env.Environment;
import java.awt.Color;
import java.nio.file.Path;
import java.util.Objects;

public class SimpleEnvironment
implements Environment {
    private final Environment fallback;
    private Path tempDirectory;
    private Integer nrOfImagesToCache;
    private Integer mergeCacheSize;
    private Integer swapCacheSize;
    private Integer documentCacheSize;
    private Integer maxImageSize;
    private Integer overallTimeout;
    private Boolean parallelProcessing;
    private Double allowedDiffInPercent;
    private Color expectedColor;
    private Color actualColor;

    public SimpleEnvironment() {
        this(DefaultEnvironment.create());
    }

    public SimpleEnvironment(Environment fallback) {
        Objects.requireNonNull(fallback, "fallback is null");
        this.fallback = fallback;
    }

    @Override
    public Path getTempDirectory() {
        return this.tempDirectory != null ? this.tempDirectory : this.fallback.getTempDirectory();
    }

    public SimpleEnvironment setTempDirectory(Path tempDirectory) {
        this.tempDirectory = tempDirectory;
        return this;
    }

    @Override
    public int getNrOfImagesToCache() {
        return this.nrOfImagesToCache != null ? this.nrOfImagesToCache.intValue() : this.fallback.getNrOfImagesToCache();
    }

    public SimpleEnvironment setNrOfImagesToCache(int nrOfImagesToCache) {
        this.nrOfImagesToCache = nrOfImagesToCache;
        return this;
    }

    @Override
    public int getMergeCacheSize() {
        return this.mergeCacheSize != null ? this.mergeCacheSize.intValue() : this.fallback.getMergeCacheSize();
    }

    public SimpleEnvironment setMergeCacheSize(int mergeCacheSize) {
        this.mergeCacheSize = mergeCacheSize;
        return this;
    }

    @Override
    public int getSwapCacheSize() {
        return this.swapCacheSize != null ? this.swapCacheSize.intValue() : this.fallback.getSwapCacheSize();
    }

    public SimpleEnvironment setSwapCacheSize(int swapCacheSize) {
        this.swapCacheSize = swapCacheSize;
        return this;
    }

    @Override
    public int getDocumentCacheSize() {
        return this.documentCacheSize != null ? this.documentCacheSize.intValue() : this.fallback.getDocumentCacheSize();
    }

    public SimpleEnvironment setDocumentCacheSize(int documentCacheSize) {
        this.documentCacheSize = documentCacheSize;
        return this;
    }

    @Override
    public int getMaxImageSize() {
        return this.maxImageSize != null ? this.maxImageSize.intValue() : this.fallback.getMaxImageSize();
    }

    public SimpleEnvironment setMaxImageSize(int maxImageSize) {
        this.maxImageSize = maxImageSize;
        return this;
    }

    @Override
    public int getOverallTimeout() {
        return this.overallTimeout != null ? this.overallTimeout.intValue() : this.fallback.getOverallTimeout();
    }

    public SimpleEnvironment setOverallTimeout(int overallTimeout) {
        this.overallTimeout = overallTimeout;
        return this;
    }

    @Override
    public boolean useParallelProcessing() {
        return this.parallelProcessing != null ? this.parallelProcessing.booleanValue() : this.fallback.useParallelProcessing();
    }

    public SimpleEnvironment setParallelProcessing(boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
        return this;
    }

    @Override
    public double getAllowedDiffInPercent() {
        return this.allowedDiffInPercent != null ? this.allowedDiffInPercent.doubleValue() : this.fallback.getAllowedDiffInPercent();
    }

    public SimpleEnvironment setAllowedDiffInPercent(double allowedDiffInPercent) {
        this.allowedDiffInPercent = allowedDiffInPercent;
        return this;
    }

    @Override
    public Color getExpectedColor() {
        return this.expectedColor != null ? this.expectedColor : this.fallback.getExpectedColor();
    }

    public SimpleEnvironment setExpectedColor(Color expectedColor) {
        this.expectedColor = expectedColor;
        return this;
    }

    @Override
    public Color getActualColor() {
        return this.actualColor != null ? this.actualColor : this.fallback.getActualColor();
    }

    public SimpleEnvironment setActualColor(Color actualColor) {
        this.actualColor = actualColor;
        return this;
    }
}

