/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import de.redsix.pdfcompare.CompareResultImpl;
import de.redsix.pdfcompare.ImageWithDimension;
import de.redsix.pdfcompare.PageDiffCalculator;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.TreeMap;

public class CompareResultWithExpectedAndActual
extends CompareResultImpl {
    private final Map<Integer, ImageWithDimension> expectedImages = new TreeMap<Integer, ImageWithDimension>();
    private final Map<Integer, ImageWithDimension> actualImages = new TreeMap<Integer, ImageWithDimension>();

    @Override
    public void addPage(PageDiffCalculator diffCalculator, int pageIndex, ImageWithDimension expectedImage, ImageWithDimension actualImage, ImageWithDimension diffImage) {
        super.addPage(diffCalculator, pageIndex, expectedImage, actualImage, diffImage);
        this.expectedImages.put(pageIndex, expectedImage);
        this.actualImages.put(pageIndex, actualImage);
    }

    @Override
    protected boolean keepImages() {
        return true;
    }

    public synchronized BufferedImage getDiffImage(int page) {
        return this.getBufferedImageOrNull((ImageWithDimension)this.diffImages.get(page));
    }

    public BufferedImage getExpectedImage(int page) {
        return this.getBufferedImageOrNull(this.expectedImages.get(page));
    }

    public BufferedImage getActualImage(int page) {
        return this.getBufferedImageOrNull(this.actualImages.get(page));
    }

    private BufferedImage getBufferedImageOrNull(ImageWithDimension imageWithDimension) {
        return imageWithDimension == null ? null : imageWithDimension.bufferedImage;
    }
}

