/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import de.redsix.pdfcompare.CompareResult;
import de.redsix.pdfcompare.FileUtils;
import de.redsix.pdfcompare.ImageWithDimension;
import de.redsix.pdfcompare.PageDiffCalculator;
import de.redsix.pdfcompare.ResourceCacheWithLimitedImages;
import de.redsix.pdfcompare.Utilities;
import de.redsix.pdfcompare.env.Environment;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.ResourceCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompareResultWithSwap
extends CompareResult {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCompareResultWithSwap.class);
    private Path tempDir;
    private boolean hasImages = false;
    private boolean swapped;
    private ExecutorService swapExecutor;

    @Override
    public boolean writeTo(String filename) {
        if (!this.swapped) {
            return super.writeTo(filename);
        }
        this.swapToDisk();
        Utilities.shutdownAndAwaitTermination(this.swapExecutor, "Swap");
        try {
            LOG.trace("Merging...");
            Instant start = Instant.now();
            PDFMergerUtility mergerUtility = new PDFMergerUtility();
            mergerUtility.setDestinationFileName(filename + ".pdf");
            for (Path path : FileUtils.getPaths(this.getTempDir(), "partial_*")) {
                mergerUtility.addSource(path.toFile());
            }
            mergerUtility.mergeDocuments(Utilities.getMemorySettings(this.environment.getMergeCacheSize()));
            Instant end = Instant.now();
            LOG.trace("Merging took: " + Duration.between(start, end).toMillis() + "ms");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.tempDir != null) {
                FileUtils.removeTempDir(this.tempDir);
            }
        }
        return this.isEqual;
    }

    @Override
    public synchronized void addPage(PageDiffCalculator diffCalculator, int pageIndex, ImageWithDimension expectedImage, ImageWithDimension actualImage, ImageWithDimension diffImage) {
        super.addPage(diffCalculator, pageIndex, expectedImage, actualImage, diffImage);
        this.hasImages = true;
        if (this.needToSwap()) {
            this.swapToDisk();
            this.afterSwap();
        }
    }

    protected void afterSwap() {
    }

    protected abstract boolean needToSwap();

    private synchronized Executor getExecutor(Environment environment) {
        if (this.swapExecutor == null) {
            this.swapExecutor = Utilities.blockingExecutor("Swap", 0, 2, 1, environment);
        }
        return this.swapExecutor;
    }

    private synchronized void swapToDisk() {
        if (!this.diffImages.isEmpty()) {
            TreeMap images = new TreeMap();
            Iterator iterator = this.diffImages.entrySet().iterator();
            int previousPage = (Integer)this.diffImages.keySet().iterator().next();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if ((Integer)entry.getKey() > previousPage + 1) continue;
                images.put(entry.getKey(), entry.getValue());
                iterator.remove();
                previousPage = (Integer)entry.getKey();
            }
            if (!images.isEmpty()) {
                this.swapped = true;
                this.getExecutor(this.environment).execute(() -> {
                    LOG.trace("Swapping {} pages to disk", (Object)images.size());
                    Instant start = Instant.now();
                    int minPageIndex = (Integer)images.keySet().iterator().next();
                    LOG.trace("minPageIndex: {}", (Object)minPageIndex);
                    try (PDDocument document = new PDDocument(Utilities.getMemorySettings(this.environment.getSwapCacheSize()));){
                        document.setResourceCache((ResourceCache)new ResourceCacheWithLimitedImages(this.environment));
                        this.addImagesToDocument(document, images);
                        Path tempDir = this.getTempDir();
                        Path tempFile = tempDir.resolve(String.format("partial_%06d.pdf", minPageIndex));
                        document.save(tempFile.toFile());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    Instant end = Instant.now();
                    LOG.trace("Swapping took: {}ms", (Object)Duration.between(start, end).toMillis());
                });
            }
        }
    }

    @Override
    protected boolean hasImages() {
        return this.hasImages;
    }

    private synchronized Path getTempDir() throws IOException {
        if (this.tempDir == null) {
            this.tempDir = FileUtils.createTempDir("PdfCompare");
        }
        return this.tempDir;
    }

    protected void finalize() throws Throwable {
        if (this.swapExecutor != null) {
            this.swapExecutor.shutdown();
        }
    }
}

