/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import de.redsix.pdfcompare.ImageWithDimension;
import de.redsix.pdfcompare.ResultCollector;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public class CompareResult
implements ResultCollector {
    protected final Map<Integer, ImageWithDimension> diffImages = new TreeMap<Integer, ImageWithDimension>();
    protected boolean isEqual = true;
    protected boolean hasDifferenceInExclusion = false;
    private boolean expectedOnly;
    private boolean actualOnly;

    public boolean writeTo(String filename) {
        if (!this.hasImages()) {
            return this.isEqual;
        }
        try (PDDocument document = new PDDocument();){
            this.addImagesToDocument(document);
            document.save(filename + ".pdf");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.isEqual;
    }

    protected boolean hasImages() {
        return !this.diffImages.isEmpty();
    }

    protected void addImagesToDocument(PDDocument document) throws IOException {
        this.addImagesToDocument(document, this.diffImages);
    }

    protected void addImagesToDocument(PDDocument document, Map<Integer, ImageWithDimension> images) throws IOException {
        Iterator<Map.Entry<Integer, ImageWithDimension>> iterator = images.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, ImageWithDimension> entry = iterator.next();
            if (!this.keepImages()) {
                iterator.remove();
            }
            this.addPageToDocument(document, entry.getValue());
        }
    }

    protected void addPageToDocument(PDDocument document, ImageWithDimension image) throws IOException {
        PDPage page = new PDPage(new PDRectangle(image.width, image.height));
        document.addPage(page);
        PDImageXObject imageXObject = LosslessFactory.createFromImage((PDDocument)document, (BufferedImage)image.bufferedImage);
        try (PDPageContentStream contentStream = new PDPageContentStream(document, page);){
            contentStream.drawImage(imageXObject, 0.0f, 0.0f, image.width, image.height);
        }
    }

    protected boolean keepImages() {
        return false;
    }

    @Override
    public synchronized void addPage(boolean hasDifferences, boolean hasDifferenceInExclusion, int pageIndex, ImageWithDimension expectedImage, ImageWithDimension actualImage, ImageWithDimension diffImage) {
        Objects.requireNonNull(expectedImage, "expectedImage is null");
        Objects.requireNonNull(actualImage, "actualImage is null");
        Objects.requireNonNull(diffImage, "diffImage is null");
        this.hasDifferenceInExclusion |= hasDifferenceInExclusion;
        if (hasDifferences) {
            this.isEqual = false;
        }
        this.diffImages.put(pageIndex, diffImage);
    }

    @Override
    public void noPagesFound() {
        this.isEqual = false;
    }

    public boolean isEqual() {
        return this.isEqual;
    }

    public boolean isNotEqual() {
        return !this.isEqual;
    }

    public boolean hasDifferenceInExclusion() {
        return this.hasDifferenceInExclusion;
    }

    public boolean hasOnlyExpected() {
        return this.expectedOnly;
    }

    public boolean hasOnlyActual() {
        return this.actualOnly;
    }

    public boolean hasOnlyOneDoc() {
        return this.expectedOnly || this.actualOnly;
    }

    public synchronized int getNumberOfPages() {
        if (!this.hasImages()) {
            return 0;
        }
        return Collections.max(this.diffImages.keySet());
    }

    public void expectedOnly() {
        this.expectedOnly = true;
    }

    public void actualOnly() {
        this.actualOnly = true;
    }
}

