/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import de.redsix.pdfcompare.BlockingHandler;
import de.redsix.pdfcompare.FileUtils;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utilities {
    private static final Logger LOG = LoggerFactory.getLogger(Utilities.class);

    public static MemoryUsageSetting getMemorySettings(int bytes) throws IOException {
        return MemoryUsageSetting.setupMixed((long)bytes).setTempDir(FileUtils.createTempDir("PdfBox").toFile());
    }

    public static ExecutorService blockingExecutor(String name, int coreThreads, int maxThreads, int queueCapacity) {
        return new ThreadPoolExecutor(coreThreads, maxThreads, 3L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(queueCapacity), new NamedThreadFactory(name), new BlockingHandler());
    }

    public static ExecutorService blockingExecutor(String name, int threads, int queueCapacity) {
        return new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(queueCapacity), new NamedThreadFactory(name), new BlockingHandler());
    }

    public static void shutdownAndAwaitTermination(ExecutorService executor, String executorName) {
        if (executor != null) {
            executor.shutdown();
            try {
                int timeout = 15;
                TimeUnit unit = TimeUnit.MINUTES;
                if (!executor.awaitTermination(15L, unit)) {
                    LOG.error("Awaiting Shutdown of Executor '{}' timed out after {} {}", new Object[]{executorName, 15, unit});
                }
            }
            catch (InterruptedException e) {
                LOG.warn("Awaiting Shutdown of Executor '{}' was interrupted", (Object)executorName);
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void await(CountDownLatch latch, String latchName) {
        try {
            int timeout = 15;
            TimeUnit unit = TimeUnit.MINUTES;
            if (!latch.await(15L, unit)) {
                LOG.error("Awaiting Latch '{}' timed out after {} {}", new Object[]{latchName, 15, unit});
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Awaiting Latch '{}' was interrupted", (Object)latchName);
            Thread.currentThread().interrupt();
        }
    }

    static class NamedThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        NamedThreadFactory(String name) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = name + "-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement());
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

