/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import de.redsix.pdfcompare.CompareResult;
import de.redsix.pdfcompare.DiffImage;
import de.redsix.pdfcompare.Environment;
import de.redsix.pdfcompare.Exclusions;
import de.redsix.pdfcompare.ImageWithDimension;
import de.redsix.pdfcompare.ResourceCacheWithLimitedImages;
import de.redsix.pdfcompare.ResultCollector;
import de.redsix.pdfcompare.Utilities;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.ResourceCache;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfComparator<T extends CompareResult> {
    private static final Logger LOG = LoggerFactory.getLogger(PdfComparator.class);
    public static final int DPI = 300;
    private static final int EXTRA_RGB = new Color(0, 160, 0).getRGB();
    private static final int MISSING_RGB = new Color(220, 0, 0).getRGB();
    public static final int MARKER_WIDTH = 20;
    private final Exclusions exclusions = new Exclusions();
    private InputStreamSupplier expectedStreamSupplier;
    private InputStreamSupplier actualStreamSupplier;
    private ExecutorService drawExecutor = Utilities.blockingExecutor("Draw", 1, 50);
    private ExecutorService parrallelDrawExecutor = Utilities.blockingExecutor("ParallelDraw", 2, 4);
    private ExecutorService diffExecutor = Utilities.blockingExecutor("Diff", 1, 2);
    private final T compareResult;

    private PdfComparator(T compareResult) {
        Objects.requireNonNull(compareResult, "compareResult is null");
        this.compareResult = compareResult;
    }

    public PdfComparator(String expectedPdfFilename, String actualPdfFilename) throws IOException {
        this(expectedPdfFilename, actualPdfFilename, new CompareResult());
    }

    public PdfComparator(String expectedPdfFilename, String actualPdfFilename, T compareResult) throws IOException {
        this(compareResult);
        Objects.requireNonNull(expectedPdfFilename, "expectedPdfFilename is null");
        Objects.requireNonNull(actualPdfFilename, "actualPdfFilename is null");
        if (!expectedPdfFilename.equals(actualPdfFilename)) {
            this.expectedStreamSupplier = () -> Files.newInputStream(Paths.get(expectedPdfFilename, new String[0]), new OpenOption[0]);
            this.actualStreamSupplier = () -> Files.newInputStream(Paths.get(actualPdfFilename, new String[0]), new OpenOption[0]);
        }
    }

    public PdfComparator(Path expectedPath, Path actualPath) throws IOException {
        this(expectedPath, actualPath, new CompareResult());
    }

    public PdfComparator(Path expectedPath, Path actualPath, T compareResult) throws IOException {
        this(compareResult);
        Objects.requireNonNull(expectedPath, "expectedPath is null");
        Objects.requireNonNull(actualPath, "actualPath is null");
        if (!expectedPath.equals(actualPath)) {
            this.expectedStreamSupplier = () -> Files.newInputStream(expectedPath, new OpenOption[0]);
            this.actualStreamSupplier = () -> Files.newInputStream(actualPath, new OpenOption[0]);
        }
    }

    public PdfComparator(File expectedFile, File actualFile) throws IOException {
        this(expectedFile, actualFile, new CompareResult());
    }

    public PdfComparator(File expectedFile, File actualFile, T compareResult) throws IOException {
        this(compareResult);
        Objects.requireNonNull(expectedFile, "expectedFile is null");
        Objects.requireNonNull(actualFile, "actualFile is null");
        if (!expectedFile.equals(actualFile)) {
            this.expectedStreamSupplier = () -> new FileInputStream(expectedFile);
            this.actualStreamSupplier = () -> new FileInputStream(actualFile);
        }
    }

    public PdfComparator(InputStream expectedPdfIS, InputStream actualPdfIS) {
        this(expectedPdfIS, actualPdfIS, new CompareResult());
    }

    public PdfComparator(InputStream expectedPdfIS, InputStream actualPdfIS, T compareResult) {
        this(compareResult);
        Objects.requireNonNull(expectedPdfIS, "expectedPdfIS is null");
        Objects.requireNonNull(actualPdfIS, "actualPdfIS is null");
        if (!expectedPdfIS.equals(actualPdfIS)) {
            this.expectedStreamSupplier = () -> expectedPdfIS;
            this.actualStreamSupplier = () -> actualPdfIS;
        }
    }

    public PdfComparator<T> withIgnore(String ignoreFilename) {
        Objects.requireNonNull(ignoreFilename, "ignoreFilename is null");
        this.exclusions.readExclusions(ignoreFilename);
        return this;
    }

    public PdfComparator<T> withIgnore(File ignoreFile) {
        Objects.requireNonNull(ignoreFile, "ignoreFile is null");
        this.exclusions.readExclusions(ignoreFile);
        return this;
    }

    public PdfComparator<T> withIgnore(Path ignorePath) {
        Objects.requireNonNull(ignorePath, "ignorePath is null");
        this.exclusions.readExclusions(ignorePath);
        return this;
    }

    public PdfComparator<T> withIgnore(InputStream ignoreIS) {
        Objects.requireNonNull(ignoreIS, "ignoreIS is null");
        this.exclusions.readExclusions(ignoreIS);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T compare() throws IOException {
        try {
            if (this.expectedStreamSupplier == null && this.actualStreamSupplier == null) {
                T t = this.compareResult;
                return t;
            }
            try (InputStream expectedStream = this.expectedStreamSupplier.get();){
                try (InputStream actualStream = this.actualStreamSupplier.get();
                     PDDocument expectedDocument = PDDocument.load((InputStream)expectedStream, (MemoryUsageSetting)Utilities.getMemorySettings(Environment.getDocumentCacheSize()));){
                    expectedDocument.setResourceCache((ResourceCache)new ResourceCacheWithLimitedImages());
                    PDFRenderer expectedPdfRenderer = new PDFRenderer(expectedDocument);
                    try (PDDocument actualDocument = PDDocument.load((InputStream)actualStream, (MemoryUsageSetting)Utilities.getMemorySettings(Environment.getDocumentCacheSize()));){
                        actualDocument.setResourceCache((ResourceCache)new ResourceCacheWithLimitedImages());
                        PDFRenderer actualPdfRenderer = new PDFRenderer(actualDocument);
                        int minPageCount = Math.min(expectedDocument.getNumberOfPages(), actualDocument.getNumberOfPages());
                        CountDownLatch latch = new CountDownLatch(minPageCount);
                        for (int pageIndex = 0; pageIndex < minPageCount; ++pageIndex) {
                            this.drawImage(latch, pageIndex, expectedDocument, actualDocument, expectedPdfRenderer, actualPdfRenderer);
                        }
                        Utilities.await(latch, "FullCompare");
                        Utilities.shutdownAndAwaitTermination(this.drawExecutor, "Draw");
                        Utilities.shutdownAndAwaitTermination(this.parrallelDrawExecutor, "Parallel Draw");
                        Utilities.shutdownAndAwaitTermination(this.diffExecutor, "Diff");
                        if (expectedDocument.getNumberOfPages() > minPageCount) {
                            this.addExtraPages(expectedDocument, expectedPdfRenderer, minPageCount, MISSING_RGB, true);
                        } else if (actualDocument.getNumberOfPages() > minPageCount) {
                            this.addExtraPages(actualDocument, actualPdfRenderer, minPageCount, EXTRA_RGB, false);
                        }
                    }
                }
                catch (NoSuchFileException ex) {
                    this.addSingleDocumentToResult(expectedStream, MISSING_RGB);
                }
            }
            catch (NoSuchFileException ex) {
                try (InputStream actualStream = this.actualStreamSupplier.get();){
                    this.addSingleDocumentToResult(actualStream, EXTRA_RGB);
                }
                catch (NoSuchFileException innerEx) {
                    LOG.warn("No files found to compare. Tried Expected: '{}' and Actual: '{}'", (Object)ex.getFile(), (Object)innerEx.getFile());
                    ((CompareResult)this.compareResult).noPagesFound();
                }
            }
        }
        finally {
            this.compareResult.done();
        }
        return this.compareResult;
    }

    private void drawImage(CountDownLatch latch, int pageIndex, PDDocument expectedDocument, PDDocument actualDocument, PDFRenderer expectedPdfRenderer, PDFRenderer actualPdfRenderer) {
        this.drawExecutor.execute(() -> {
            int timeout = 3;
            TimeUnit unit = TimeUnit.MINUTES;
            try {
                LOG.trace("Drawing page {}", (Object)pageIndex);
                Future<ImageWithDimension> expectedImageFuture = this.parrallelDrawExecutor.submit(() -> this.renderPageAsImage(expectedDocument, expectedPdfRenderer, pageIndex));
                Future<ImageWithDimension> actualImageFuture = this.parrallelDrawExecutor.submit(() -> this.renderPageAsImage(actualDocument, actualPdfRenderer, pageIndex));
                ImageWithDimension expectedImage = expectedImageFuture.get(3L, unit);
                ImageWithDimension actualImage = actualImageFuture.get(3L, unit);
                DiffImage diffImage = new DiffImage(expectedImage, actualImage, pageIndex, this.exclusions, (ResultCollector)this.compareResult);
                LOG.trace("Enqueueing page {}.", (Object)pageIndex);
                this.diffExecutor.execute(() -> {
                    LOG.trace("Diffing page {}", (Object)diffImage);
                    diffImage.diffImages();
                    LOG.trace("DONE Diffing page {}", (Object)diffImage);
                });
                LOG.trace("DONE drawing page {}", (Object)pageIndex);
            }
            catch (InterruptedException e) {
                LOG.warn("Waiting for Future was interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e) {
                LOG.error("Waiting for Future timed out after {} {}", new Object[]{3, unit, e});
            }
            catch (ExecutionException e) {
                LOG.error("Error while rendering page {}", (Object)pageIndex, (Object)e);
            }
            finally {
                latch.countDown();
            }
        });
    }

    private void addSingleDocumentToResult(InputStream expectedPdfIS, int markerColor) throws IOException {
        try (PDDocument expectedDocument = PDDocument.load((InputStream)expectedPdfIS);){
            PDFRenderer expectedPdfRenderer = new PDFRenderer(expectedDocument);
            this.addExtraPages(expectedDocument, expectedPdfRenderer, 0, markerColor, true);
        }
    }

    private void addExtraPages(PDDocument document, PDFRenderer pdfRenderer, int minPageCount, int color, boolean expected) throws IOException {
        for (int pageIndex = minPageCount; pageIndex < document.getNumberOfPages(); ++pageIndex) {
            int i;
            ImageWithDimension image = this.renderPageAsImage(document, pdfRenderer, pageIndex);
            DataBuffer dataBuffer = image.bufferedImage.getRaster().getDataBuffer();
            for (i = 0; i < image.bufferedImage.getWidth() * 20; ++i) {
                dataBuffer.setElem(i, color);
            }
            for (i = 0; i < image.bufferedImage.getHeight(); ++i) {
                for (int j = 0; j < 20; ++j) {
                    dataBuffer.setElem(i * image.bufferedImage.getWidth() + j, color);
                }
            }
            if (expected) {
                ((CompareResult)this.compareResult).addPage(true, false, pageIndex, image, PdfComparator.blank(image), image);
                continue;
            }
            ((CompareResult)this.compareResult).addPage(true, false, pageIndex, PdfComparator.blank(image), image, image);
        }
    }

    private static ImageWithDimension blank(ImageWithDimension image) {
        return new ImageWithDimension(new BufferedImage(image.bufferedImage.getWidth(), image.bufferedImage.getHeight(), image.bufferedImage.getType()), image.width, image.height);
    }

    private ImageWithDimension renderPageAsImage(PDDocument document, PDFRenderer expectedPdfRenderer, int pageIndex) throws IOException {
        BufferedImage bufferedImage = expectedPdfRenderer.renderImageWithDPI(pageIndex, 300.0f);
        PDRectangle mediaBox = document.getPage(pageIndex).getMediaBox();
        return new ImageWithDimension(bufferedImage, mediaBox.getWidth(), mediaBox.getHeight());
    }

    public T getResult() {
        return this.compareResult;
    }

    @FunctionalInterface
    private static interface InputStreamSupplier {
        public InputStream get() throws IOException;
    }
}

