/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.Scrollable;

class ImagePanel
extends JPanel
implements Scrollable {
    private static final double[] zoomStages = new double[]{0.125, 0.25, 0.5, 1.0, 2.0, 4.0, 8.0};
    private BufferedImage image;
    private double zoom = 1.0;
    private boolean zoomPage = true;
    private int oldWidth;
    private int oldHeight;
    private Dimension viewSize;

    public ImagePanel(BufferedImage image) {
        this.image = image;
        this.oldWidth = this.getImageWidth();
        this.oldHeight = this.getImageHeight();
    }

    private int getImageHeight() {
        return this.image == null ? 1 : this.image.getHeight();
    }

    private int getImageWidth() {
        return this.image == null ? 1 : this.image.getWidth();
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.image == null) {
            return;
        }
        g.setColor(Color.DARK_GRAY);
        g.clearRect(0, 0, this.oldWidth, this.oldHeight);
        if (this.zoomPage) {
            this.setZoomToPage();
        }
        g.drawImage(this.image, 0, 0, this.getZoomWidth(), this.getZoomHeight(), null);
    }

    private void setZoomToPage() {
        double zoomWidth = (double)this.viewSize.width / (double)this.getImageWidth();
        double zoomHeight = (double)this.viewSize.height / (double)this.getImageHeight();
        this.zoom = Math.min(zoomWidth, zoomHeight);
    }

    private void getWidthZoom() {
        this.zoom = (double)this.getVisibleRect().width / (double)this.getImageWidth();
    }

    private int getZoomWidth() {
        return (int)Math.floor((double)this.getImageWidth() * this.zoom);
    }

    private int getZoomHeight() {
        return (int)Math.floor((double)this.getImageHeight() * this.zoom);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.zoomPage) {
            return this.getParentSize();
        }
        return new Dimension(this.getZoomWidth(), this.getZoomHeight());
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.zoomPage) {
            return this.getParentSize();
        }
        return new Dimension(this.getZoomWidth(), this.getZoomHeight());
    }

    private Dimension getParentSize() {
        return this.viewSize == null ? new Dimension(this.getImageWidth(), this.getImageHeight()) : this.viewSize;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return (int)(40.0 * this.zoom);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return visibleRect.height - 40;
        }
        return visibleRect.width - 40;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void increaseZoom() {
        this.zoomPage = false;
        if (this.zoom < zoomStages[zoomStages.length - 1]) {
            int i;
            for (i = 0; i < zoomStages.length && zoomStages[i] <= this.zoom; ++i) {
            }
            this.zoom = zoomStages[i];
            this.revalidate();
        }
    }

    public void decreaseZoom() {
        this.zoomPage = false;
        if (this.zoom > zoomStages[0]) {
            int i;
            this.oldWidth = this.getZoomWidth();
            this.oldHeight = this.getZoomHeight();
            for (i = 0; i < zoomStages.length && zoomStages[i] < this.zoom; ++i) {
            }
            this.zoom = zoomStages[i - 1];
            this.revalidate();
        }
    }

    public void setImage(BufferedImage image) {
        this.oldWidth = this.getZoomWidth();
        this.oldHeight = this.getZoomHeight();
        this.image = image;
        this.revalidate();
        this.repaint();
    }

    public void zoomPage() {
        this.oldWidth = this.getZoomWidth();
        this.oldHeight = this.getZoomHeight();
        this.zoomPage = true;
        this.revalidate();
        this.repaint();
    }

    public void zoom100() {
        this.zoomPage = false;
        this.oldWidth = this.getZoomWidth();
        this.oldHeight = this.getZoomHeight();
        this.zoom = 1.0;
        this.revalidate();
        this.repaint();
    }

    public void setViewSize(Dimension viewSize) {
        this.viewSize = viewSize;
        this.revalidate();
    }
}

