/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import de.redsix.pdfcompare.Environment;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.DefaultResourceCache;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceCacheWithLimitedImages
extends DefaultResourceCache {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceCacheWithLimitedImages.class);
    private final Map<COSObject, SoftReference<PDXObject>> xobjects = new LinkedHashMap<COSObject, SoftReference<PDXObject>>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<COSObject, SoftReference<PDXObject>> eldest) {
            return this.size() > Environment.getNrOfImagesToCache();
        }
    };

    public PDXObject getXObject(COSObject indirect) throws IOException {
        SoftReference<PDXObject> xobject = this.xobjects.get(indirect);
        if (xobject != null) {
            return xobject.get();
        }
        return null;
    }

    public void put(COSObject indirect, PDXObject xobject) throws IOException {
        PDImageXObject imageObj;
        int length = xobject.getStream().getLength();
        if (length > Environment.getMaxImageSize()) {
            LOG.trace("Not caching image with Size: {}", (Object)length);
            return;
        }
        if (xobject instanceof PDImageXObject && (imageObj = (PDImageXObject)xobject).getWidth() * imageObj.getHeight() > Environment.getMaxImageSize()) {
            return;
        }
        this.xobjects.put(indirect, new SoftReference<PDXObject>(xobject));
    }
}

