/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import de.redsix.pdfcompare.CompareResult;
import de.redsix.pdfcompare.FileUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;

public class CompareResultWithDiskStorage
extends CompareResult {
    private Path tempDir;
    private boolean hasImages = false;

    @Override
    protected void addImagesToDocument(PDDocument document) throws IOException {
        for (Path path : FileUtils.getPaths(this.getTempDir(), "image_*")) {
            this.addPageToDocument(document, ImageIO.read(path.toFile()));
        }
        FileUtils.removeTempDir(this.getTempDir());
    }

    @Override
    public synchronized void addPage(boolean hasDifferences, boolean hasDifferenceInExclusion, int pageIndex, BufferedImage expectedImage, BufferedImage actualImage, BufferedImage diffImage) {
        Objects.requireNonNull(expectedImage, "expectedImage is null");
        Objects.requireNonNull(actualImage, "actualImage is null");
        Objects.requireNonNull(diffImage, "diffImage is null");
        this.hasImages = true;
        this.hasDifferenceInExclusion |= hasDifferenceInExclusion;
        if (hasDifferences) {
            this.isEqual = false;
        }
        this.storeImage(pageIndex, diffImage);
    }

    @Override
    protected boolean hasImages() {
        return this.hasImages;
    }

    private void storeImage(int pageIndex, BufferedImage diffImage) {
        try {
            Path tmpDir = this.getTempDir();
            ImageIO.write((RenderedImage)diffImage, "PNG", tmpDir.resolve(String.format("image_%06d", pageIndex)).toFile());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write image to Temp Dir", e);
        }
    }

    private synchronized Path getTempDir() throws IOException {
        if (this.tempDir == null) {
            this.tempDir = FileUtils.createTempDir("PdfCompare");
        }
        return this.tempDir;
    }
}

