/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import de.redsix.pdfcompare.BlockingHandler;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utilities {
    private static final Logger LOG = LoggerFactory.getLogger(Utilities.class);

    public static ExecutorService blockingExecutor(int threads, int queueCapacity) {
        return new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(queueCapacity), new BlockingHandler());
    }

    public static void shutdownAndAwaitTermination(ExecutorService executor, String executorName) {
        executor.shutdown();
        try {
            executor.awaitTermination(20L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            LOG.warn("Awaiting Shutdown of Executor '{}' was interrupted", (Object)executorName);
        }
    }

    public static void await(CountDownLatch latch, String latchName) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOG.warn("Awaiting Latch '{}' was interrupted", (Object)latchName);
        }
    }
}

