/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import de.redsix.pdfcompare.CompareResult;
import de.redsix.pdfcompare.FileUtils;
import de.redsix.pdfcompare.Utilities;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompareResultWithSwap
extends CompareResult {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCompareResultWithSwap.class);
    private Path tempDir;
    private boolean hasImages = false;
    private boolean swapped;
    private ExecutorService swapExecutor = Executors.newFixedThreadPool(5);

    @Override
    public boolean writeTo(String filename) {
        if (!this.swapped) {
            return super.writeTo(filename);
        }
        this.swapToDisk();
        Utilities.shutdownAndAwaitTermination(this.swapExecutor, "Swap");
        try {
            LOG.debug("Merging...");
            Instant start = Instant.now();
            PDFMergerUtility mergerUtility = new PDFMergerUtility();
            mergerUtility.setDestinationFileName(filename + ".pdf");
            for (Path path : FileUtils.getPaths(this.getTempDir(), "partial_*")) {
                mergerUtility.addSource(path.toFile());
            }
            mergerUtility.mergeDocuments(MemoryUsageSetting.setupMainMemoryOnly());
            Instant end = Instant.now();
            System.out.println("Merging took: " + Duration.between(start, end).toMillis() + "ms");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.isEqual;
    }

    @Override
    public synchronized void addPage(boolean hasDifferences, boolean hasDifferenceInExclusion, int pageIndex, BufferedImage expectedImage, BufferedImage actualImage, BufferedImage diffImage) {
        super.addPage(hasDifferences, hasDifferenceInExclusion, pageIndex, expectedImage, actualImage, diffImage);
        this.hasImages = true;
        if (this.needToSwap()) {
            this.swapToDisk();
            this.afterSwap();
        }
    }

    protected void afterSwap() {
    }

    protected abstract boolean needToSwap();

    private synchronized void swapToDisk() {
        if (!this.diffImages.isEmpty()) {
            TreeMap images = new TreeMap();
            Iterator iterator = this.diffImages.entrySet().iterator();
            int previousPage = (Integer)this.diffImages.keySet().iterator().next();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if ((Integer)entry.getKey() > previousPage + 1) continue;
                images.put(entry.getKey(), entry.getValue());
                iterator.remove();
                previousPage = (Integer)entry.getKey();
            }
            if (!images.isEmpty()) {
                this.swapped = true;
                this.swapExecutor.execute(() -> {
                    LOG.debug("Swapping {} pages to disk", (Object)images.size());
                    Instant start = Instant.now();
                    int minPageIndex = (Integer)images.keySet().iterator().next();
                    LOG.debug("minPageIndex: {}", (Object)minPageIndex);
                    try (PDDocument document = new PDDocument();){
                        this.addImagesToDocument(document, images);
                        Path tempDir = this.getTempDir();
                        Path tempFile = tempDir.resolve(String.format("partial_%06d.pdf", minPageIndex));
                        document.save(tempFile.toFile());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    Instant end = Instant.now();
                    System.out.println("Swap took: " + Duration.between(start, end).toMillis() + "ms");
                });
            }
        }
    }

    @Override
    protected boolean hasImages() {
        return this.hasImages;
    }

    private synchronized Path getTempDir() throws IOException {
        if (this.tempDir == null) {
            this.tempDir = FileUtils.createTempDir("PdfCompare");
        }
        return this.tempDir;
    }
}

