/*
 * Decompiled with CFR 0.152.
 */
package de.oscillation.maven.doxygen;

import de.oscillation.maven.doxygen.DoxyfileBooleanValue;
import de.oscillation.maven.doxygen.DoxygenOutputGenerator;
import de.oscillation.maven.doxygen.DoxygenOutputGeneratorName;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.WriterStreamConsumer;

public abstract class AbstractDoxygenMojo
extends AbstractMojo {
    private static final String DOXYGEN_OUTPUT_DIRECTORY_KEY = "OUTPUT_DIRECTORY";
    @Parameter(property="doxygen.doxyfilePath", defaultValue="Doxyfile", required=true)
    private String doxyfilePath;
    @Parameter(property="doxygen.autogen", defaultValue="false", required=true)
    private boolean autogen;
    @Parameter(property="doxygen.executablePath", defaultValue="doxygen", required=true)
    private String executablePath;
    @Parameter(property="doxygen.workingDirectory", defaultValue="${basedir}", required=true)
    private File workingDirectory;
    protected StringWriter stringWriter = new StringWriter();
    protected StreamConsumer systemOut = new WriterStreamConsumer((Writer)this.stringWriter);
    protected StreamConsumer systemErr = new WriterStreamConsumer((Writer)this.stringWriter);
    protected String outputBasePath = ".";
    protected List<DoxygenOutputGenerator> outputGenerators = new ArrayList<DoxygenOutputGenerator>();

    protected void checkExecutable() {
        try {
            Commandline cl = new Commandline();
            cl.setWorkingDirectory(this.getWorkingDirectory());
            cl.setExecutable(this.getExecutablePath());
            cl.createArg().setValue("--version");
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)this.systemOut, (StreamConsumer)this.systemErr);
            if (exitCode != 0) {
                this.getLog().error((CharSequence)(this.getExecutablePath() + ": command not found"));
                return;
            }
        }
        catch (CommandLineException e) {
            this.getLog().error((CharSequence)("CommandLineException: " + e.getMessage()));
            return;
        }
    }

    protected void ensureDoxyfile() {
        File doxyfile = new File(this.getWorkingDirectory() + File.separator + this.getDoxyfilePath());
        if (!doxyfile.exists()) {
            if (this.shouldAutogen()) {
                Commandline cl = new Commandline();
                cl.setWorkingDirectory(this.getWorkingDirectory());
                cl.setExecutable(this.getExecutablePath());
                cl.createArg().setValue("-g");
                cl.createArg().setValue(this.getDoxyfilePath());
                try {
                    this.getLog().info((CharSequence)("Generating " + this.getDoxyfilePath()));
                    CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)this.systemOut, (StreamConsumer)this.systemErr);
                    for (String line : this.stringWriter.toString().split("\n")) {
                        this.getLog().debug((CharSequence)line);
                    }
                }
                catch (CommandLineException e) {
                    this.getLog().error((CharSequence)("CommandLineException: " + e.getMessage()));
                    return;
                }
            } else {
                this.getLog().error((CharSequence)("configuration file " + this.getDoxyfilePath() + " not found!"));
                return;
            }
        }
    }

    protected void readOutputParametersFromDoxyfile() {
        for (DoxygenOutputGeneratorName name : DoxygenOutputGeneratorName.values()) {
            this.outputGenerators.add(new DoxygenOutputGenerator(name));
        }
        try {
            File doxyfile = new File(this.getWorkingDirectory() + File.separator + this.getDoxyfilePath());
            Scanner input = new Scanner(doxyfile);
            while (input.hasNext()) {
                String line = input.nextLine();
                if (line.indexOf(DOXYGEN_OUTPUT_DIRECTORY_KEY) > -1) {
                    String[] tokens = line.split("=");
                    if (tokens.length < 2) continue;
                    this.outputBasePath = tokens[1].trim();
                    continue;
                }
                for (DoxygenOutputGenerator generator : this.outputGenerators) {
                    String[] tokens;
                    if (line.indexOf(generator.getActivationConfigKey()) > -1) {
                        tokens = line.split("=");
                        if (tokens.length < 2 || tokens[1].indexOf(DoxyfileBooleanValue.getTrueString()) <= -1) continue;
                        generator.setActive(true);
                        continue;
                    }
                    if (line.indexOf(generator.getOutputPathConfigKey()) <= -1 || (tokens = line.split("=")).length < 2) continue;
                    generator.setOutputPath(tokens[1].trim());
                }
            }
        }
        catch (FileNotFoundException e) {
            this.getLog().error((CharSequence)("Doxyfile does not exist: " + e.getMessage()));
        }
    }

    protected abstract void performTasks();

    public void execute() throws MojoExecutionException {
        this.checkExecutable();
        this.ensureDoxyfile();
        this.readOutputParametersFromDoxyfile();
        this.performTasks();
    }

    public boolean shouldAutogen() {
        return this.autogen;
    }

    public String getDoxyfilePath() {
        return this.doxyfilePath;
    }

    public String getExecutablePath() {
        return this.executablePath;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }
}

