/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.parser.node;

import de.neuland.jade4j.compiler.IndentWriter;
import de.neuland.jade4j.exceptions.JadeCompilerException;
import de.neuland.jade4j.expression.ExpressionHandler;
import de.neuland.jade4j.model.JadeModel;
import de.neuland.jade4j.parser.node.AttributedNode;
import de.neuland.jade4j.parser.node.BlockNode;
import de.neuland.jade4j.parser.node.CaseConditionNode;
import de.neuland.jade4j.parser.node.CaseNode;
import de.neuland.jade4j.parser.node.ConditionalNode;
import de.neuland.jade4j.parser.node.IfConditionNode;
import de.neuland.jade4j.parser.node.MixinNode;
import de.neuland.jade4j.parser.node.Node;
import de.neuland.jade4j.template.JadeTemplate;
import de.neuland.jade4j.util.ArgumentSplitter;
import java.util.ArrayList;
import java.util.List;

public class MixinInjectNode
extends AttributedNode {
    protected List<String> arguments = new ArrayList<String>();

    @Override
    public void execute(IndentWriter writer, JadeModel model, JadeTemplate template) throws JadeCompilerException {
        MixinNode mixin = model.getMixin(this.getName());
        if (mixin == null) {
            throw new JadeCompilerException((Node)this, template.getTemplateLoader(), "mixin " + this.getName() + " is not defined");
        }
        try {
            mixin = (MixinNode)mixin.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
        if (this.hasBlock()) {
            List<BlockNode> injectionPoints = this.getInjectionPoints(mixin.getBlock());
            for (BlockNode point : injectionPoints) {
                point.getNodes().add(this.block);
            }
        }
        model.pushScope();
        model.put("block", (Object)this.hasBlock());
        this.writeVariables(model, mixin, template);
        this.writeAttributes(model, mixin, template);
        mixin.getBlock().execute(writer, model, template);
        model.popScope();
    }

    private List<BlockNode> getInjectionPoints(Node block) {
        ArrayList<BlockNode> result = new ArrayList<BlockNode>();
        for (Node node : block.getNodes()) {
            if (node instanceof BlockNode && !node.hasNodes()) {
                result.add((BlockNode)node);
                continue;
            }
            if (node instanceof ConditionalNode) {
                for (IfConditionNode ifConditionNode : ((ConditionalNode)node).getConditions()) {
                    result.addAll(this.getInjectionPoints(ifConditionNode.getBlock()));
                }
                continue;
            }
            if (node instanceof CaseNode) {
                for (CaseConditionNode caseConditionNode : ((CaseNode)node).getCaseConditionNodes()) {
                    result.addAll(this.getInjectionPoints(caseConditionNode.getBlock()));
                }
                continue;
            }
            if (!node.hasBlock()) continue;
            result.addAll(this.getInjectionPoints(node.getBlock()));
        }
        return result;
    }

    private void writeVariables(JadeModel model, MixinNode mixin, JadeTemplate template) {
        List<String> names = mixin.getArguments();
        List<String> values = this.arguments;
        if (names == null) {
            return;
        }
        for (int i = 0; i < names.size(); ++i) {
            String key = names.get(i);
            Object value = null;
            if (i < values.size()) {
                value = values.get(i);
            }
            if (value != null) {
                try {
                    value = ExpressionHandler.evaluateExpression(values.get(i), model);
                }
                catch (Throwable e) {
                    throw new JadeCompilerException((Node)this, template.getTemplateLoader(), e);
                }
            }
            if (key == null) continue;
            model.put(key, value);
        }
    }

    private void writeAttributes(JadeModel model, MixinNode mixin, JadeTemplate template) {
        model.put("attributes", (Object)this.mergeInheritedAttributes(model));
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public void setArguments(String arguments) {
        this.arguments.clear();
        this.arguments = ArgumentSplitter.split(arguments);
    }
}

