/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.parser.node;

import de.neuland.jade4j.model.JadeModel;
import de.neuland.jade4j.parser.node.ExpressionString;
import de.neuland.jade4j.parser.node.Node;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AttributedNode
extends Node {
    protected Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    protected Map<String, List<Object>> preparedAttributeValues = new HashMap<String, List<Object>>();
    protected boolean inheritsAttributes = false;

    public void addAttribute(String key, Object value) {
        if ("attributes".equals(key)) {
            this.inheritsAttributes = true;
        } else {
            this.addAttribute(this.attributes, key, value);
        }
    }

    public String getAttribute(String key) {
        return (String)this.attributes.get(key);
    }

    public void addAttributes(Map<String, Object> attributeMap) {
        for (String key : attributeMap.keySet()) {
            this.addAttribute(key, attributeMap.get(key));
        }
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    protected Map<String, Object> mergeInheritedAttributes(JadeModel model) {
        Object o;
        Map<String, Object> mergedAttributes = this.attributes;
        if (this.inheritsAttributes && (o = model.get("attributes")) != null && o instanceof Map) {
            Map inheritedAttributes = (Map)o;
            for (Map.Entry entry : inheritedAttributes.entrySet()) {
                this.addAttribute(mergedAttributes, (String)entry.getKey(), entry.getValue());
            }
        }
        return mergedAttributes;
    }

    private void addAttribute(Map<String, Object> map, String key, Object newValue) {
        if ("class".equals(key) && this.attributes.containsKey(key)) {
            String value1 = this.attributeValueToString(this.attributes.get(key));
            String value2 = this.attributeValueToString(newValue);
            this.attributes.put(key, value1 + " " + value2);
        } else {
            this.attributes.put(key, newValue);
        }
    }

    private String attributeValueToString(Object value) {
        if (value instanceof ExpressionString) {
            String expression = ((ExpressionString)value).getValue();
            return "#{" + expression + "}";
        }
        return value.toString();
    }

    @Override
    public AttributedNode clone() throws CloneNotSupportedException {
        AttributedNode clone = (AttributedNode)super.clone();
        if (this.attributes != null) {
            clone.attributes = new LinkedHashMap<String, Object>(this.attributes);
        }
        clone.preparedAttributeValues = new HashMap<String, List<Object>>();
        return clone;
    }
}

