/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.lexer;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Scanner {
    private String input;

    public Scanner(Reader reader) {
        this.initFromReader(reader);
    }

    public void consume(int length) {
        this.input = this.input.substring(length);
    }

    public String findInLine(String re) {
        Pattern pattern = Pattern.compile(re);
        Matcher matcher = pattern.matcher(this.input);
        if (matcher.find(0)) {
            int end = matcher.end();
            return this.input.substring(0, end);
        }
        return null;
    }

    private void initFromReader(Reader reader) {
        try {
            StringBuilder sb = new StringBuilder();
            BufferedReader in = new BufferedReader(reader);
            String s = in.readLine();
            while (s != null) {
                if (StringUtils.isNotBlank((CharSequence)s)) {
                    sb.append(s);
                }
                sb.append("\n");
                s = in.readLine();
            }
            this.input = sb.toString();
            if (StringUtils.isNotBlank((CharSequence)this.input)) {
                this.input = sb.toString().replaceAll("\\r\\n|\\r", "\\n");
            }
            in.close();
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public char charAt(int i) {
        return this.input.charAt(i);
    }

    public boolean beginnsWithWhitespace() {
        return this.input.charAt(0) == ' ' || this.input.charAt(0) == '\t';
    }

    public boolean isNotEmpty() {
        return StringUtils.isNotEmpty((CharSequence)this.input);
    }

    private boolean isEmpty() {
        return !this.isNotEmpty();
    }

    public boolean isNotLineBreak() {
        return this.isEmpty() || this.input.charAt(0) != '\n';
    }

    public String getPipelessText() {
        int i = this.input.indexOf(10);
        if (-1 == i) {
            i = this.input.length();
        }
        String str = this.input.substring(0, i);
        this.consume(str.length());
        return str.trim();
    }

    public String getInput() {
        return this.input;
    }

    public Matcher getMatcherForPattern(String regexp) {
        Pattern pattern = Pattern.compile(regexp);
        return pattern.matcher(this.input);
    }

    public boolean isIntendantionViolated() {
        return this.input != null && this.input.length() > 0 && (' ' == this.input.charAt(0) || '\t' == this.input.charAt(0));
    }

    public boolean isBlankLine() {
        return this.input != null && this.input.length() > 0 && '\n' == this.input.charAt(0);
    }

    public boolean isAdditionalBlankline() {
        return this.input.length() > 2 && this.input.charAt(0) == '\n' && this.input.charAt(1) == '\n';
    }
}

