/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.exceptions;

import de.neuland.jade4j.Jade4J;
import de.neuland.jade4j.template.TemplateLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class JadeException
extends RuntimeException {
    private static final long serialVersionUID = -8189536050437574552L;
    private String filename;
    private int lineNumber;
    private TemplateLoader templateLoader;

    public JadeException(String message, String filename, int lineNumber, TemplateLoader templateLoader, Throwable e) {
        super(message, e);
        this.filename = filename;
        this.lineNumber = lineNumber;
        this.templateLoader = templateLoader;
    }

    public JadeException(String message) {
        super(message);
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public List<String> getTemplateLines() {
        try {
            String line;
            ArrayList<String> result = new ArrayList<String>();
            Reader reader = this.templateLoader.getReader(this.filename);
            BufferedReader in = new BufferedReader(reader);
            while ((line = in.readLine()) != null) {
                result.add(line);
            }
            return result;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String toString() {
        return this.getClass() + " " + this.getFilename() + ":" + this.getLineNumber() + "\n" + this.getMessage();
    }

    public String toHtmlString() {
        return this.toHtmlString(null);
    }

    public String toHtmlString(String generatedHtml) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("filename", this.filename);
        model.put("linenumber", this.lineNumber);
        model.put("message", this.getMessage());
        model.put("lines", this.getTemplateLines());
        model.put("exception", this.getName());
        if (generatedHtml != null) {
            model.put("html", generatedHtml);
        }
        try {
            URL url = JadeException.class.getResource("/error.jade");
            return Jade4J.render(url, model, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getName() {
        return this.getClass().getSimpleName().replaceAll("([A-Z])", " $1").trim();
    }
}

