/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.refarch.integration.s3.adapter.in.rest;

import de.muenchen.refarch.integration.s3.adapter.in.rest.dto.FileSizesInFolderDto;
import de.muenchen.refarch.integration.s3.adapter.in.rest.dto.FilesInFolderDto;
import de.muenchen.refarch.integration.s3.adapter.in.rest.dto.FilesMetadataInFolderDto;
import de.muenchen.refarch.integration.s3.adapter.in.rest.mapper.FileMetadataMapper;
import de.muenchen.refarch.integration.s3.adapter.in.rest.mapper.FileSizesInFolderMapper;
import de.muenchen.refarch.integration.s3.adapter.in.rest.mapper.FilesInFolderMapper;
import de.muenchen.refarch.integration.s3.application.port.in.FolderOperationsInPort;
import de.muenchen.refarch.integration.s3.domain.model.FileSizesInFolder;
import de.muenchen.refarch.integration.s3.domain.model.FilesInFolder;
import de.muenchen.refarch.integration.s3.domain.model.FilesMetadataInFolder;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotEmpty;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(name="FolderAPI", description="API to interact with folders")
@RequestMapping(value={"/folder"})
public class FolderController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FolderController.class);
    private final FolderOperationsInPort folderOperations;
    private final FilesInFolderMapper filesInFolderMapper;
    private final FileSizesInFolderMapper fileSizesInFolderMapper;
    private final FileMetadataMapper fileMetadataMapper;

    @DeleteMapping
    @Operation(description="Deletes the folder specified in the parameter")
    public ResponseEntity<Void> deleteFolder(@RequestParam @NotEmpty String pathToFolder) {
        try {
            log.info("Received a request for deletion of a certain folder.");
            this.folderOperations.deleteFolder(pathToFolder);
            return ResponseEntity.noContent().build();
        }
        catch (Exception exception) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exception.getMessage(), (Throwable)exception);
        }
    }

    @GetMapping
    @Operation(description="Returns all file paths for the folder specified in the parameter")
    public ResponseEntity<FilesInFolderDto> getAllFilesInFolderRecursively(@RequestParam @NotEmpty String pathToFolder) {
        try {
            log.info("Received a request for getting file paths for a certain folder.");
            FilesInFolder filesInFolder = this.folderOperations.getAllFilesInFolderRecursively(pathToFolder);
            FilesInFolderDto filesInFolderDto = this.filesInFolderMapper.model2Dto(filesInFolder);
            return ResponseEntity.ok((Object)filesInFolderDto);
        }
        catch (Exception exception) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, exception.getMessage(), (Throwable)exception);
        }
    }

    @GetMapping(value={"/metadata"})
    @Operation(description="Returns metadata of all files for the folder specified in the parameter")
    public ResponseEntity<FilesMetadataInFolderDto> getMetadataOfAllFilesInFolderRecursively(@RequestParam @NotEmpty String pathToFolder) {
        try {
            log.info("Received a request for getting metadata of all files for a certain folder.");
            FilesMetadataInFolder filesMetadataInFolder = this.folderOperations.getMetadataOfAllFilesInFolderRecursively(pathToFolder);
            FilesMetadataInFolderDto filesMetadataInFolderDto = this.fileMetadataMapper.model2Dto(filesMetadataInFolder);
            return ResponseEntity.ok((Object)filesMetadataInFolderDto);
        }
        catch (Exception exception) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, exception.getMessage(), (Throwable)exception);
        }
    }

    @GetMapping(value={"/size"})
    @Operation(description="Returns all file sizes for the folder specified in the parameter")
    public ResponseEntity<FileSizesInFolderDto> getAllFileSizesInFolderRecursively(@RequestParam @NotEmpty String pathToFolder) {
        try {
            log.info("Received a request for getting file sizes for a certain folder.");
            FileSizesInFolder fileSizesInFolder = this.folderOperations.getAllFileSizesInFolderRecursively(pathToFolder);
            FileSizesInFolderDto filesizesInFolderDto = this.fileSizesInFolderMapper.model2Dto(fileSizesInFolder);
            return ResponseEntity.ok((Object)filesizesInFolderDto);
        }
        catch (Exception exception) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, exception.getMessage(), (Throwable)exception);
        }
    }

    @Generated
    public FolderController(FolderOperationsInPort folderOperations, FilesInFolderMapper filesInFolderMapper, FileSizesInFolderMapper fileSizesInFolderMapper, FileMetadataMapper fileMetadataMapper) {
        this.folderOperations = folderOperations;
        this.filesInFolderMapper = filesInFolderMapper;
        this.fileSizesInFolderMapper = fileSizesInFolderMapper;
        this.fileMetadataMapper = fileMetadataMapper;
    }
}

