/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.refarch.integration.s3.client.repository.presignedurl;

import de.muenchen.refarch.integration.s3.client.api.FileApiApi;
import de.muenchen.refarch.integration.s3.client.exception.DocumentStorageClientErrorException;
import de.muenchen.refarch.integration.s3.client.exception.DocumentStorageException;
import de.muenchen.refarch.integration.s3.client.exception.DocumentStorageServerErrorException;
import de.muenchen.refarch.integration.s3.client.model.FileDataDto;
import de.muenchen.refarch.integration.s3.client.model.PresignedUrlDto;
import de.muenchen.refarch.integration.s3.client.repository.presignedurl.PresignedUrlRepository;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestClientException;
import reactor.core.publisher.Mono;

public class PresignedUrlRestRepository
implements PresignedUrlRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PresignedUrlRestRepository.class);
    private final FileApiApi fileApi;

    public String getPresignedUrlGetFile(String pathToFile, int expireInMinutes) throws DocumentStorageClientErrorException, DocumentStorageServerErrorException, DocumentStorageException {
        try {
            Mono<PresignedUrlDto> presignedUrlDto = this.fileApi.get(pathToFile, expireInMinutes);
            return ((PresignedUrlDto)presignedUrlDto.block()).getUrl();
        }
        catch (HttpClientErrorException exception) {
            String message = String.format("The request to create a presigned url to get a file failed %s.", exception.getStatusCode());
            log.error(message);
            throw new DocumentStorageClientErrorException(message, (Exception)((Object)exception));
        }
        catch (HttpServerErrorException exception) {
            String message = String.format("The request to create a presigned url to get a file failed %s.", exception.getStatusCode());
            log.error(message);
            throw new DocumentStorageServerErrorException(message, (Exception)((Object)exception));
        }
        catch (RestClientException exception) {
            String message = "The request to create a presigned url to get a file failed.";
            log.error("The request to create a presigned url to get a file failed.");
            throw new DocumentStorageException("The request to create a presigned url to get a file failed.", (Exception)((Object)exception));
        }
    }

    public String getPresignedUrlSaveFile(String pathToFile, int expireInMinutes) throws DocumentStorageClientErrorException, DocumentStorageServerErrorException, DocumentStorageException {
        try {
            FileDataDto fileDataDto = new FileDataDto();
            fileDataDto.setPathToFile(pathToFile);
            fileDataDto.setExpiresInMinutes(expireInMinutes);
            Mono<PresignedUrlDto> presignedUrlDto = this.fileApi.save(fileDataDto);
            return ((PresignedUrlDto)presignedUrlDto.block()).getUrl();
        }
        catch (HttpClientErrorException exception) {
            String message = String.format("The request to create a presigned save url failed %s.", exception.getStatusCode());
            log.error(message);
            throw new DocumentStorageClientErrorException(message, (Exception)((Object)exception));
        }
        catch (HttpServerErrorException exception) {
            String message = String.format("The request to create a presigned save url failed %s.", exception.getStatusCode());
            log.error(message);
            throw new DocumentStorageServerErrorException(message, (Exception)((Object)exception));
        }
        catch (RestClientException exception) {
            String message = "The request to create a presigned save url failed.";
            log.error("The request to create a presigned save url failed.");
            throw new DocumentStorageException("The request to create a presigned save url failed.", (Exception)((Object)exception));
        }
    }

    public String getPresignedUrlUpdateFile(String pathToFile, int expireInMinutes) throws DocumentStorageClientErrorException, DocumentStorageServerErrorException, DocumentStorageException {
        try {
            FileDataDto fileDataDto = new FileDataDto();
            fileDataDto.setPathToFile(pathToFile);
            fileDataDto.setExpiresInMinutes(expireInMinutes);
            Mono<PresignedUrlDto> presignedUrlDto = this.fileApi.update(fileDataDto);
            return ((PresignedUrlDto)presignedUrlDto.block()).getUrl();
        }
        catch (HttpClientErrorException exception) {
            String message = String.format("The request to create a presigned update url failed %s.", exception.getStatusCode());
            log.error(message);
            throw new DocumentStorageClientErrorException(message, (Exception)((Object)exception));
        }
        catch (HttpServerErrorException exception) {
            String message = String.format("The request to create a presigned update url failed %s.", exception.getStatusCode());
            log.error(message);
            throw new DocumentStorageServerErrorException(message, (Exception)((Object)exception));
        }
        catch (RestClientException exception) {
            String message = "The request to create a presigned update url failed.";
            log.error("The request to create a presigned update url failed.");
            throw new DocumentStorageException("The request to create a presigned update url failed.", (Exception)((Object)exception));
        }
    }

    public String getPresignedUrlDeleteFile(String pathToFile, int expireInMinutes) throws DocumentStorageClientErrorException, DocumentStorageServerErrorException, DocumentStorageException {
        try {
            Mono<PresignedUrlDto> presignedUrlDto = this.fileApi.deleteFile(pathToFile, expireInMinutes);
            return ((PresignedUrlDto)presignedUrlDto.block()).getUrl();
        }
        catch (HttpClientErrorException exception) {
            String message = String.format("The request to create a presigned url to delete a file failed %s.", exception.getStatusCode());
            log.error(message);
            throw new DocumentStorageClientErrorException(message, (Exception)((Object)exception));
        }
        catch (HttpServerErrorException exception) {
            String message = String.format("The request to create a presigned url to delete a file failed %s.", exception.getStatusCode());
            log.error(message);
            throw new DocumentStorageServerErrorException(message, (Exception)((Object)exception));
        }
        catch (RestClientException exception) {
            String message = "The request to create a presigned url to delete a file failed.";
            log.error("The request to create a presigned url to delete a file failed.");
            throw new DocumentStorageException("The request to create a presigned url to delete a file failed.", (Exception)((Object)exception));
        }
    }

    @Generated
    public PresignedUrlRestRepository(FileApiApi fileApi) {
        this.fileApi = fileApi;
    }
}

