/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.refarch.integration.s3.client.configuration;

import de.muenchen.refarch.integration.s3.client.ApiClient;
import de.muenchen.refarch.integration.s3.client.api.FileApiApi;
import de.muenchen.refarch.integration.s3.client.api.FolderApiApi;
import de.muenchen.refarch.integration.s3.client.domain.model.SupportedFileExtensions;
import de.muenchen.refarch.integration.s3.client.properties.S3IntegrationClientProperties;
import de.muenchen.refarch.integration.s3.client.repository.DocumentStorageFileRepository;
import de.muenchen.refarch.integration.s3.client.repository.DocumentStorageFileRestRepository;
import de.muenchen.refarch.integration.s3.client.repository.DocumentStorageFolderRepository;
import de.muenchen.refarch.integration.s3.client.repository.DocumentStorageFolderRestRepository;
import de.muenchen.refarch.integration.s3.client.repository.mapper.FileMetadataMapper;
import de.muenchen.refarch.integration.s3.client.repository.mapper.FileMetadataMapperImpl;
import de.muenchen.refarch.integration.s3.client.repository.presignedurl.PresignedUrlRepository;
import de.muenchen.refarch.integration.s3.client.repository.presignedurl.PresignedUrlRestRepository;
import de.muenchen.refarch.integration.s3.client.repository.transfer.S3FileTransferRepository;
import de.muenchen.refarch.integration.s3.client.service.FileValidationService;
import jakarta.annotation.PostConstruct;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.AuthorizedClientServiceOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.reactive.function.client.ServletOAuth2AuthorizedClientExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
@ComponentScan(basePackages={"de.muenchen.refarch.integration.s3.client"})
@EnableConfigurationProperties(value={S3IntegrationClientProperties.class})
public class S3IntegrationClientAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(S3IntegrationClientAutoConfiguration.class);
    public final S3IntegrationClientProperties s3IntegrationClientProperties;

    @PostConstruct
    public void init() {
        log.info("s3 rest client security is {}.", (Object)(this.s3IntegrationClientProperties.isEnableSecurity() ? "enabled" : "disabled"));
    }

    @Bean
    @ConditionalOnProperty(prefix="refarch.s3.client", name={"enable-security"}, havingValue="true")
    public ApiClient securedApiClient(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientService authorizedClientService) {
        ApiClient apiClient = new ApiClient(this.authenticatedWebClient(clientRegistrationRepository, authorizedClientService));
        apiClient.setBasePath(this.s3IntegrationClientProperties.getDocumentStorageUrl());
        return apiClient;
    }

    @Bean
    @ConditionalOnProperty(prefix="refarch.s3.client", name={"enable-security"}, havingValue="false", matchIfMissing=true)
    public ApiClient apiClient() {
        ApiClient apiClient = new ApiClient(WebClient.builder().build());
        apiClient.setBasePath(this.s3IntegrationClientProperties.getDocumentStorageUrl());
        return apiClient;
    }

    private WebClient authenticatedWebClient(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientService authorizedClientService) {
        ServletOAuth2AuthorizedClientExchangeFilterFunction oauth = new ServletOAuth2AuthorizedClientExchangeFilterFunction((OAuth2AuthorizedClientManager)new AuthorizedClientServiceOAuth2AuthorizedClientManager(clientRegistrationRepository, authorizedClientService));
        oauth.setDefaultClientRegistrationId("s3");
        return WebClient.builder().apply(oauth.oauth2Configuration()).build();
    }

    @Bean
    @ConditionalOnBean(value={SupportedFileExtensions.class})
    public FileValidationService fileService(SupportedFileExtensions supportedFileExtensions) {
        return new FileValidationService((Map)supportedFileExtensions, this.s3IntegrationClientProperties.getMaxFileSize(), this.s3IntegrationClientProperties.getMaxBatchSize());
    }

    @Bean
    @ConditionalOnMissingBean(value={SupportedFileExtensions.class})
    public FileValidationService fileServiceFromS3IntegrationClientProperties() {
        return new FileValidationService(this.s3IntegrationClientProperties.getSupportedFileExtensions(), this.s3IntegrationClientProperties.getMaxFileSize(), this.s3IntegrationClientProperties.getMaxBatchSize());
    }

    @Bean
    @ConditionalOnMissingBean
    public FileApiApi fileApiApi(ApiClient apiClient) {
        return new FileApiApi(apiClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public FolderApiApi folderApiApi(ApiClient apiClient) {
        return new FolderApiApi(apiClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public PresignedUrlRepository presignedUrlRepository(FileApiApi fileApi) {
        return new PresignedUrlRestRepository(fileApi);
    }

    @Bean
    @ConditionalOnMissingBean
    public DocumentStorageFileRepository documentStorageFileRepository(PresignedUrlRepository presignedUrlRepository, S3FileTransferRepository s3FileTransferRepository, FileApiApi fileApi) {
        return new DocumentStorageFileRestRepository(presignedUrlRepository, s3FileTransferRepository, fileApi);
    }

    @Bean
    @ConditionalOnMissingBean
    public DocumentStorageFolderRepository documentStorageFolderRepository(FolderApiApi folderApi) {
        return new DocumentStorageFolderRestRepository(folderApi, (FileMetadataMapper)new FileMetadataMapperImpl());
    }

    @Generated
    public S3IntegrationClientAutoConfiguration(S3IntegrationClientProperties s3IntegrationClientProperties) {
        this.s3IntegrationClientProperties = s3IntegrationClientProperties;
    }
}

