/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.refarch.integration.s3.client.repository;

import de.muenchen.refarch.integration.s3.application.port.in.FileOperationsInPort;
import de.muenchen.refarch.integration.s3.client.exception.DocumentStorageClientErrorException;
import de.muenchen.refarch.integration.s3.client.exception.DocumentStorageException;
import de.muenchen.refarch.integration.s3.client.exception.DocumentStorageServerErrorException;
import de.muenchen.refarch.integration.s3.client.repository.DocumentStorageFileRepository;
import de.muenchen.refarch.integration.s3.client.repository.presignedurl.PresignedUrlRepository;
import de.muenchen.refarch.integration.s3.client.repository.transfer.S3FileTransferRepository;
import de.muenchen.refarch.integration.s3.domain.exception.FileSystemAccessException;

public class DocumentStorageFileJavaRepository
extends DocumentStorageFileRepository {
    private final FileOperationsInPort fileOperationsInPort;

    public DocumentStorageFileJavaRepository(PresignedUrlRepository presignedUrlRepository, S3FileTransferRepository s3FileTransferRepository, FileOperationsInPort fileOperationsInPort) {
        super(presignedUrlRepository, s3FileTransferRepository);
        this.fileOperationsInPort = fileOperationsInPort;
    }

    public Long getFileSize(String pathToFile) throws DocumentStorageClientErrorException, DocumentStorageServerErrorException, DocumentStorageException {
        try {
            return this.fileOperationsInPort.getFileSize(pathToFile).fileSize();
        }
        catch (FileSystemAccessException e) {
            throw new DocumentStorageException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

