/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.refarch.integration.s3.client.configuration;

import de.muenchen.refarch.integration.s3.application.port.in.FileOperationsInPort;
import de.muenchen.refarch.integration.s3.application.port.in.FileOperationsPresignedUrlInPort;
import de.muenchen.refarch.integration.s3.application.port.in.FolderOperationsInPort;
import de.muenchen.refarch.integration.s3.client.domain.model.SupportedFileExtensions;
import de.muenchen.refarch.integration.s3.client.properties.S3IntegrationClientProperties;
import de.muenchen.refarch.integration.s3.client.repository.DocumentStorageFileJavaRepository;
import de.muenchen.refarch.integration.s3.client.repository.DocumentStorageFileRepository;
import de.muenchen.refarch.integration.s3.client.repository.DocumentStorageFolderJavaRepository;
import de.muenchen.refarch.integration.s3.client.repository.DocumentStorageFolderRepository;
import de.muenchen.refarch.integration.s3.client.repository.mapper.FileMetadataMapper;
import de.muenchen.refarch.integration.s3.client.repository.presignedurl.PresignedUrlJavaRepository;
import de.muenchen.refarch.integration.s3.client.repository.presignedurl.PresignedUrlRepository;
import de.muenchen.refarch.integration.s3.client.repository.transfer.S3FileTransferRepository;
import de.muenchen.refarch.integration.s3.client.service.FileValidationService;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(basePackages={"de.muenchen.refarch.integration.s3.client"})
@EnableConfigurationProperties(value={S3IntegrationClientProperties.class})
public class S3IntegrationClientAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(S3IntegrationClientAutoConfiguration.class);
    public final S3IntegrationClientProperties s3IntegrationClientProperties;

    @Bean
    @ConditionalOnBean(value={SupportedFileExtensions.class})
    public FileValidationService fileService(SupportedFileExtensions supportedFileExtensions) {
        return new FileValidationService((Map)supportedFileExtensions, this.s3IntegrationClientProperties.getMaxFileSize(), this.s3IntegrationClientProperties.getMaxBatchSize());
    }

    @Bean
    @ConditionalOnMissingBean(value={SupportedFileExtensions.class})
    public FileValidationService fileServiceFromS3IntegrationClientProperties() {
        return new FileValidationService(this.s3IntegrationClientProperties.getSupportedFileExtensions(), this.s3IntegrationClientProperties.getMaxFileSize(), this.s3IntegrationClientProperties.getMaxBatchSize());
    }

    @Bean
    @ConditionalOnMissingBean
    public PresignedUrlRepository presignedUrlRepository(FileOperationsPresignedUrlInPort fileOperationsPresignedUrlInPort) {
        return new PresignedUrlJavaRepository(fileOperationsPresignedUrlInPort);
    }

    @Bean
    @ConditionalOnMissingBean
    public DocumentStorageFileRepository documentStorageFileRepository(PresignedUrlRepository presignedUrlRepository, S3FileTransferRepository s3FileTransferRepository, FileOperationsInPort fileOperationsInPort) {
        return new DocumentStorageFileJavaRepository(presignedUrlRepository, s3FileTransferRepository, fileOperationsInPort);
    }

    @Bean
    @ConditionalOnMissingBean
    public DocumentStorageFolderRepository documentStorageFolderRepository(FolderOperationsInPort folderOperationsInPort, FileMetadataMapper fileMetadataMapper) {
        return new DocumentStorageFolderJavaRepository(folderOperationsInPort, fileMetadataMapper);
    }

    @Generated
    public S3IntegrationClientAutoConfiguration(S3IntegrationClientProperties s3IntegrationClientProperties) {
        this.s3IntegrationClientProperties = s3IntegrationClientProperties;
    }
}

