/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.refarch.integration.s3.application.usecase;

import de.muenchen.refarch.integration.s3.application.port.in.FileOperationsPresignedUrlInPort;
import de.muenchen.refarch.integration.s3.application.port.out.S3OutPort;
import de.muenchen.refarch.integration.s3.domain.exception.FileExistenceException;
import de.muenchen.refarch.integration.s3.domain.exception.FileSystemAccessException;
import de.muenchen.refarch.integration.s3.domain.model.FileData;
import de.muenchen.refarch.integration.s3.domain.model.PresignedUrl;
import io.minio.http.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FileOperationsPresignedUrlUseCase
implements FileOperationsPresignedUrlInPort {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileOperationsPresignedUrlUseCase.class);
    private final S3OutPort s3OutPort;

    public static String getPathToFolder(String pathToFile) {
        return StringUtils.contains((CharSequence)pathToFile, (CharSequence)"/") ? StringUtils.substringBeforeLast((String)pathToFile, (String)"/") : "";
    }

    @Override
    public List<PresignedUrl> getPresignedUrls(List<String> paths, Method action, int expiresInMinutes) throws FileSystemAccessException {
        ArrayList<PresignedUrl> presignedUrls = new ArrayList<PresignedUrl>();
        for (String p : paths) {
            presignedUrls.addAll(this.getPresignedUrls(p, action, expiresInMinutes));
        }
        return presignedUrls;
    }

    @Override
    public PresignedUrl getPresignedUrl(String path, Method action, int expiresInMinutes) throws FileSystemAccessException {
        return new PresignedUrl(this.s3OutPort.getPresignedUrl(path, action, expiresInMinutes), path, action.toString());
    }

    @Override
    public PresignedUrl getFile(String pathToFile, int expiresInMinutes) throws FileSystemAccessException {
        if (!this.fileExists(pathToFile)) {
            String message = String.format("The file %s does not exists.", pathToFile);
            log.error(message);
            throw new FileExistenceException(message);
        }
        return this.getPresignedUrl(pathToFile, Method.GET, expiresInMinutes);
    }

    @Override
    public PresignedUrl saveFile(FileData fileData) throws FileSystemAccessException {
        if (this.fileExists(fileData.pathToFile())) {
            String message = String.format("The file %s does exists.", fileData.pathToFile());
            log.error(message);
            throw new FileExistenceException(message);
        }
        return this.getPresignedUrl(fileData.pathToFile(), Method.PUT, fileData.expiresInMinutes());
    }

    @Override
    public PresignedUrl updateFile(FileData fileData) throws FileSystemAccessException {
        return this.getPresignedUrl(fileData.pathToFile(), Method.PUT, fileData.expiresInMinutes());
    }

    @Override
    public PresignedUrl deleteFile(String pathToFile, int expiresInMinutes) throws FileSystemAccessException {
        if (!this.fileExists(pathToFile)) {
            String message = String.format("The file %s does not exists.", pathToFile);
            log.error(message);
            throw new FileExistenceException(message);
        }
        return this.getPresignedUrl(pathToFile, Method.DELETE, expiresInMinutes);
    }

    private boolean fileExists(String filePath) throws FileSystemAccessException {
        return this.s3OutPort.fileExists(filePath);
    }

    private List<PresignedUrl> getPresignedUrls(String path, Method action, int expiresInMinutes) throws FileSystemAccessException {
        if (action.equals((Object)Method.POST)) {
            return List.of(this.getPresignedUrl(path, Method.PUT, expiresInMinutes));
        }
        ArrayList<String> paths = new ArrayList<String>(this.s3OutPort.getFilePathsFromFolder(path));
        List<PresignedUrl> presignedUrlList = paths.stream().map(filePath -> this.getPresignedUrlForFile((String)filePath, action, expiresInMinutes)).filter(Objects::nonNull).collect(Collectors.toList());
        if (presignedUrlList.isEmpty()) {
            String message = String.format("The file %s does not exist.", path);
            log.error(message);
            throw new FileExistenceException(message);
        }
        return presignedUrlList;
    }

    private PresignedUrl getPresignedUrlForFile(String filePath, Method action, int expiresInMinutes) {
        try {
            String presignedUrl = this.s3OutPort.getPresignedUrl(filePath, action, expiresInMinutes);
            return new PresignedUrl(presignedUrl, filePath, action.toString());
        }
        catch (FileSystemAccessException e) {
            log.warn("File not found on path {}", (Object)filePath);
            return null;
        }
    }

    @Generated
    public FileOperationsPresignedUrlUseCase(S3OutPort s3OutPort) {
        this.s3OutPort = s3OutPort;
    }
}

