/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.refarch.integration.s3.client.service;

import de.muenchen.refarch.integration.s3.client.domain.model.SupportedFileExtensions;
import de.muenchen.refarch.integration.s3.client.exception.NoFileTypeException;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.tika.Tika;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.springframework.util.unit.DataSize;

public class FileValidationService {
    private static final String NO_FILE_EXTENSION = "No file extension found for %s";
    private final Map<String, String> supportedFileExtensions;
    private final DataSize maxFileSize;
    private final DataSize maxBatchSize;

    public FileValidationService(Map<String, String> supportedFileExtensions, DataSize maxFileSize, DataSize maxBatchSize) {
        this.supportedFileExtensions = Objects.nonNull(supportedFileExtensions) ? supportedFileExtensions : new SupportedFileExtensions();
        this.maxFileSize = maxFileSize;
        this.maxBatchSize = maxBatchSize;
    }

    public boolean isValidFileSize(byte[] file) {
        return this.isValidFileSize(file.length);
    }

    public boolean isValidFileSize(long fileSizeInBytes) {
        if (Objects.isNull(this.maxFileSize) || this.maxFileSize.toBytes() == 0L) {
            return true;
        }
        return DataSize.ofBytes((long)fileSizeInBytes).compareTo(this.maxFileSize) <= 0;
    }

    public DataSize getTotalBatchSize(Map<String, Long> fileSizesWithPaths) {
        return DataSize.ofBytes((long)fileSizesWithPaths.values().stream().mapToLong(Long::valueOf).sum());
    }

    public boolean isValidBatchSize(long batchSizeInBytes) {
        return DataSize.ofBytes((long)batchSizeInBytes).compareTo(this.maxBatchSize) <= 0;
    }

    public boolean isValidBatchSize(DataSize batchSizeInBytes) {
        if (Objects.isNull(this.maxBatchSize) || this.maxBatchSize.toBytes() == 0L) {
            return true;
        }
        return batchSizeInBytes.compareTo(this.maxBatchSize) <= 0;
    }

    public Map<String, Long> getOversizedFiles(Map<String, Long> fileSizesWithPaths) {
        return fileSizesWithPaths.entrySet().stream().filter(entry -> !this.isValidFileSize((Long)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public boolean isSupported(String type) {
        return this.supportedFileExtensions.isEmpty() || this.supportedFileExtensions.containsKey(type) || this.supportedFileExtensions.containsValue(type);
    }

    public String getFileExtension(String type) {
        MimeType mimeType;
        MimeTypes allMimeTypes = MimeTypes.getDefaultMimeTypes();
        try {
            mimeType = allMimeTypes.forName(type);
        }
        catch (MimeTypeException e) {
            throw new NoFileTypeException(String.format(NO_FILE_EXTENSION, type), (Exception)((Object)e));
        }
        String extension = mimeType.getExtension();
        int lastDotIndex = extension.lastIndexOf(46);
        if (lastDotIndex == -1) {
            throw new NoFileTypeException(String.format(NO_FILE_EXTENSION, type));
        }
        String fileExtension = extension.substring(lastDotIndex + 1);
        if (fileExtension.isEmpty()) {
            throw new NoFileTypeException(String.format(NO_FILE_EXTENSION, type));
        }
        return fileExtension;
    }

    public String detectFileType(byte[] fileContent) {
        Tika tika = new Tika();
        return tika.detect(fileContent);
    }

    @Generated
    public DataSize getMaxFileSize() {
        return this.maxFileSize;
    }

    @Generated
    public DataSize getMaxBatchSize() {
        return this.maxBatchSize;
    }
}

