/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.xjustiz.xjustiz0500straf.builder;

import de.muenchen.xjustiz.generated.CodeGDSAktentyp;
import de.muenchen.xjustiz.generated.CodeGDSAktenzeichenart;
import de.muenchen.xjustiz.generated.CodeGDSBestandteiltyp;
import de.muenchen.xjustiz.generated.CodeGDSDokumentklasseTyp3;
import de.muenchen.xjustiz.generated.CodeGDSGerichteTyp3;
import de.muenchen.xjustiz.generated.CodeGDSRegisterzeichenTyp3;
import de.muenchen.xjustiz.generated.TypeGDSAkte;
import de.muenchen.xjustiz.generated.TypeGDSAktenzeichen;
import de.muenchen.xjustiz.generated.TypeGDSBehoerde;
import de.muenchen.xjustiz.generated.TypeGDSDokument;
import de.muenchen.xjustiz.generated.TypeGDSRefSGO;
import de.muenchen.xjustiz.generated.TypeGDSSchriftgutobjekte;
import de.muenchen.xjustiz.generated.TypeGDSXdomeaAnwendungsspezifischeErweiterungType;
import de.muenchen.xjustiz.generated.TypeGDSXdomeaIdentifikationObjektType;
import de.muenchen.xjustiz.generated.TypeGDSXdomeaZeitraumType;
import de.muenchen.xjustiz.xjustiz0500straf.builder.XJustizBuilder;
import de.muenchen.xjustiz.xjustiz0500straf.content.SchriftgutContent;
import de.muenchen.xjustiz.xjustiz0500straf.content.schriftgutobjekte.Akte;
import de.muenchen.xjustiz.xjustiz0500straf.content.schriftgutobjekte.Dokument;
import de.muenchen.xjustiz.xjustiz0500straf.content.schriftgutobjekte.Identifikation;
import de.muenchen.xjustiz.xoev.XJustizProperty;
import de.muenchen.xjustiz.xoev.codelisten.XoevCodeGDS;
import de.muenchen.xjustiz.xoev.codelisten.XoevCodeGDSAktentyp;
import de.muenchen.xjustiz.xoev.codelisten.XoevCodeGDSAktenzeichenart;
import de.muenchen.xjustiz.xoev.codelisten.XoevCodeGDSBestandteiltyp;
import de.muenchen.xjustiz.xoev.codelisten.XoevCodeGDSDokumentklasse;
import de.muenchen.xjustiz.xoev.codelisten.XoevCodeGDSGerichteTyp3;
import de.muenchen.xjustiz.xoev.codelisten.XoevCodeGDSRegisterzeichen;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class SchriftgutobjektBuilder
extends XJustizBuilder {
    public SchriftgutobjektBuilder(XJustizProperty xjustizProperty) {
        super(xjustizProperty);
    }

    public TypeGDSSchriftgutobjekte build(SchriftgutContent schriftgutContent) {
        TypeGDSSchriftgutobjekte schriftobjekte = new TypeGDSSchriftgutobjekte();
        schriftgutContent.getAnschreiben().ifPresent(refsgo -> {
            TypeGDSRefSGO anschreiben = new TypeGDSRefSGO();
            anschreiben.setRefSgo((String)refsgo);
            schriftobjekte.setAnschreiben(anschreiben);
        });
        schriftgutContent.getDokumente().ifPresent(contentDokumente -> this.createDocuments((List<Dokument>)contentDokumente).forEach(d -> schriftobjekte.getDokument().add((TypeGDSDokument)d)));
        schriftgutContent.getAkten().ifPresent(contentAkten -> this.createDossier((List<Akte>)contentAkten).forEach(a -> schriftobjekte.getAkte().add((TypeGDSAkte)a)));
        return schriftobjekte;
    }

    private List<TypeGDSDokument> createDocuments(List<Dokument> contentDokumente) {
        ArrayList<TypeGDSDokument> documents = new ArrayList<TypeGDSDokument>();
        contentDokumente.forEach(contentDokument -> {
            TypeGDSDokument document = new TypeGDSDokument();
            document.setIdentifikation(SchriftgutobjektBuilder.createIdentifikation(contentDokument.getIdentifikation()));
            TypeGDSDokument.XjustizFachspezifischeDaten fachspezifischeDaten = new TypeGDSDokument.XjustizFachspezifischeDaten();
            fachspezifischeDaten.setDokumentklasse((CodeGDSDokumentklasseTyp3)this.createCodeGDSClass(XoevCodeGDS.CODE_GDS_DOKUMENTKLASSE, contentDokument.getFachspezifischeDatenDokument().getDokumentklasse().getDescriptor()));
            fachspezifischeDaten.setAnzeigename(contentDokument.getFachspezifischeDatenDokument().getAnzeigename());
            ArrayList dateien = new ArrayList();
            contentDokument.getFachspezifischeDatenDokument().getDateien().forEach(d -> {
                TypeGDSDokument.XjustizFachspezifischeDaten.Datei datei = new TypeGDSDokument.XjustizFachspezifischeDaten.Datei();
                datei.setDateiname(d.getDateiname());
                if (contentDokument.getFachspezifischeDatenDokument().getDokumentklasse() == XoevCodeGDSDokumentklasse.ANTRAG) {
                    datei.setBestandteil((CodeGDSBestandteiltyp)this.createCodeGDSClass(XoevCodeGDS.CODE_GDS_BESTANDTEILTYP, XoevCodeGDSBestandteiltyp.ORIGINAL.getDescriptor()));
                } else {
                    datei.setBestandteil((CodeGDSBestandteiltyp)this.createCodeGDSClass(XoevCodeGDS.CODE_GDS_BESTANDTEILTYP, XoevCodeGDSBestandteiltyp.REPRAESENTANT.getDescriptor()));
                }
                datei.setVersionsnummer(d.getVersionsnummer());
                dateien.add(datei);
            });
            dateien.forEach(d -> fachspezifischeDaten.getDatei().add((TypeGDSDokument.XjustizFachspezifischeDaten.Datei)d));
            document.setXjustizFachspezifischeDaten(fachspezifischeDaten);
            documents.add(document);
        });
        return documents;
    }

    private List<TypeGDSAkte> createDossier(List<Akte> contentAkten) {
        ArrayList<TypeGDSAkte> dossiers = new ArrayList<TypeGDSAkte>();
        contentAkten.forEach(contentAkte -> {
            TypeGDSAkte dossier = new TypeGDSAkte();
            contentAkte.getIdentifikation().ifPresent(identifikation -> dossier.setIdentifikation(SchriftgutobjektBuilder.createIdentifikation(identifikation)));
            contentAkte.getLaufzeit().ifPresent(laufzeit -> {
                TypeGDSXdomeaZeitraumType zeitraum = new TypeGDSXdomeaZeitraumType();
                laufzeit.getBeginn().ifPresent(zeitraum::setBeginn);
                laufzeit.getEnde().ifPresent(zeitraum::setEnde);
                dossier.setLaufzeit(zeitraum);
            });
            contentAkte.getAnwendungspezifischeErweiterung().ifPresent(anwendungsspezifischeErweiterung -> {
                TypeGDSXdomeaAnwendungsspezifischeErweiterungType erweiterung = new TypeGDSXdomeaAnwendungsspezifischeErweiterungType();
                erweiterung.setKennung(anwendungsspezifischeErweiterung.getKennung());
                erweiterung.setName(anwendungsspezifischeErweiterung.getName());
                dossier.setAnwendungsspezifischeErweiterung(erweiterung);
            });
            TypeGDSAkte.XjustizFachspezifischeDaten fachspezifischeDaten = new TypeGDSAkte.XjustizFachspezifischeDaten();
            fachspezifischeDaten.setAktentyp((CodeGDSAktentyp)this.createCodeGDSClass(XoevCodeGDS.CODE_GDS_AKTENTYP, XoevCodeGDSAktentyp.BUSSGELDAKTE.getDescriptor()));
            TypeGDSAktenzeichen aktenzeichen = new TypeGDSAktenzeichen();
            TypeGDSBehoerde behoerde = new TypeGDSBehoerde();
            behoerde.setGericht((CodeGDSGerichteTyp3)this.createCodeGDSClass(XoevCodeGDS.CODE_GDS_GERICHTE_TYP_3, XoevCodeGDSGerichteTyp3.AMTSGERICHT_MUENCHEN.getDescriptor()));
            aktenzeichen.setAuswahlAzVergebendeStation(behoerde);
            fachspezifischeDaten.getAktenzeichen().add(aktenzeichen);
            contentAkte.getFachspezifischeDatenAkte().ifPresent(fachspezifischeDatenAkte -> {
                if (fachspezifischeDatenAkte.isAktenzeichenArt()) {
                    aktenzeichen.setAzArt((CodeGDSAktenzeichenart)this.createCodeGDSClass(XoevCodeGDS.CODE_GDS_AKTENZEICHENART, XoevCodeGDSAktenzeichenart.AKTUELL.getDescriptor()));
                }
                TypeGDSAktenzeichen.AuswahlAktenzeichen auswahlAktenzeichen = new TypeGDSAktenzeichen.AuswahlAktenzeichen();
                fachspezifischeDatenAkte.getFreitext().ifPresent(freitext -> auswahlAktenzeichen.setAktenzeichenFreitext((String)freitext));
                fachspezifischeDatenAkte.getAktenzeichenAuswahlAktenzeichenAktenzeichenStrukturiert().ifPresent(auswahlAktenzeichenStrukturiert -> {
                    TypeGDSAktenzeichen.AuswahlAktenzeichen.AktenzeichenStrukturiert strukturiert = new TypeGDSAktenzeichen.AuswahlAktenzeichen.AktenzeichenStrukturiert();
                    strukturiert.setSachgebietsschluessel(auswahlAktenzeichenStrukturiert.getSachgebietsschluessel());
                    strukturiert.setZusatzkennung(auswahlAktenzeichenStrukturiert.getZusatzkennung());
                    strukturiert.setAbteilung(auswahlAktenzeichenStrukturiert.getAbteilung());
                    strukturiert.setLaufendeNummer(auswahlAktenzeichenStrukturiert.getLaufendeNummer());
                    strukturiert.setJahr(auswahlAktenzeichenStrukturiert.getJahr());
                    auswahlAktenzeichen.setAktenzeichenStrukturiert(strukturiert);
                    strukturiert.setRegister((CodeGDSRegisterzeichenTyp3)this.createCodeGDSClass(XoevCodeGDS.CODE_GDS_REGISTERZEICHEN, XoevCodeGDSRegisterzeichen.BUSSGELDVERFAHREN.getDescriptor()));
                    auswahlAktenzeichen.setAktenzeichenStrukturiert(strukturiert);
                    aktenzeichen.setAuswahlAktenzeichen(auswahlAktenzeichen);
                });
                aktenzeichen.setAuswahlAktenzeichen(auswahlAktenzeichen);
            });
            dossier.setXjustizFachspezifischeDaten(fachspezifischeDaten);
            dossiers.add(dossier);
        });
        return dossiers;
    }

    private static TypeGDSXdomeaIdentifikationObjektType createIdentifikation(Identifikation contentIdentifikation) {
        TypeGDSXdomeaIdentifikationObjektType identifikation = new TypeGDSXdomeaIdentifikationObjektType();
        identifikation.setId(contentIdentifikation.getId());
        identifikation.setNummerImUebergeordnetenContainer(contentIdentifikation.getNummerImUebergeordnetenContainer());
        return identifikation;
    }
}

