/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.xjustiz.xjustiz0500straf.builder;

import de.muenchen.xjustiz.generated.CodeGDSEreignisTyp3;
import de.muenchen.xjustiz.generated.CodeGDSGerichteTyp3;
import de.muenchen.xjustiz.generated.TypeGDSHerstellerinformation;
import de.muenchen.xjustiz.generated.TypeGDSNachrichtenkopf;
import de.muenchen.xjustiz.xjustiz0500straf.builder.Builder;
import de.muenchen.xjustiz.xjustiz0500straf.config.NachrichtenProperty;
import de.muenchen.xjustiz.xjustiz0500straf.content.NachrichtenkopfContent;
import de.muenchen.xjustiz.xoev.XJustizProperty;
import de.muenchen.xjustiz.xoev.codelisten.XoevCodeGDS;
import de.muenchen.xjustiz.xoev.codelisten.XoevCodeGDSEreignisTyp3;
import de.muenchen.xjustiz.xoev.codelisten.XoevCodeGDSGerichteTyp3;
import java.util.GregorianCalendar;
import java.util.UUID;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class NachrichtenkopfBuilder
extends Builder {
    @Value(value="${xjustiz.version}")
    protected String xJustizVersion;

    public NachrichtenkopfBuilder(XJustizProperty xjustizProperty, NachrichtenProperty nachrichtenProperty) {
        super(xjustizProperty, nachrichtenProperty);
    }

    public TypeGDSNachrichtenkopf build(NachrichtenkopfContent nachrichtenkopfContent) {
        TypeGDSNachrichtenkopf nachrichtenkopf = new TypeGDSNachrichtenkopf();
        nachrichtenkopf.setXjustizVersion(this.xJustizVersion);
        TypeGDSNachrichtenkopf.AuswahlAbsender absender = new TypeGDSNachrichtenkopf.AuswahlAbsender();
        nachrichtenkopf.getAktenzeichenAbsender().add(nachrichtenkopfContent.getAktenzeichen());
        absender.setAbsenderSonstige(this.nachrichtenProperty.getNachrichtenkopf().getAuswahlAbsenderSonstige());
        nachrichtenkopf.setAuswahlAbsender(absender);
        nachrichtenkopf.getAktenzeichenEmpfaenger().add("neu");
        TypeGDSNachrichtenkopf.AuswahlEmpfaenger empfaenger = new TypeGDSNachrichtenkopf.AuswahlEmpfaenger();
        empfaenger.setEmpfaengerGericht((CodeGDSGerichteTyp3)this.createCodeGDSClass(XoevCodeGDS.CODE_GDS_GERICHTE_TYP_3, XoevCodeGDSGerichteTyp3.AMTSGERICHT_MUENCHEN.getDescriptor()));
        nachrichtenkopf.setAuswahlEmpfaenger(empfaenger);
        try {
            nachrichtenkopf.setErstellungszeitpunkt(DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar()));
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
        nachrichtenkopf.setEigeneNachrichtenID(UUID.randomUUID().toString());
        nachrichtenkopf.getEreignis().add((CodeGDSEreignisTyp3)this.createCodeGDSClass(XoevCodeGDS.CODE_GDS_EREIGNIS_TYP_3, XoevCodeGDSEreignisTyp3.NEUEINGANG_E_HAFT.getDescriptor()));
        TypeGDSHerstellerinformation herstellerinformation = new TypeGDSHerstellerinformation();
        herstellerinformation.setNameDesProdukts(this.nachrichtenProperty.getNachrichtenkopf().getAuswahlHerstellerinformationProduktName());
        herstellerinformation.setHerstellerDesProdukts(this.nachrichtenProperty.getNachrichtenkopf().getAuswahlHerstellerinformationProdukt());
        herstellerinformation.setVersion(this.nachrichtenProperty.getNachrichtenkopf().getAuswahlHerstellerinformationProduktVersion());
        nachrichtenkopf.setHerstellerinformation(herstellerinformation);
        return nachrichtenkopf;
    }
}

