/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.xjustiz.xjustiz0500straf.builder;

import de.muenchen.xjustiz.generated.CodeGDSAnschriftstyp;
import de.muenchen.xjustiz.generated.CodeGDSGerichteTyp3;
import de.muenchen.xjustiz.generated.CodeGDSGeschlecht;
import de.muenchen.xjustiz.generated.CodeGDSRollenbezeichnungTyp3;
import de.muenchen.xjustiz.generated.CodeGDSSachgebietTyp3;
import de.muenchen.xjustiz.generated.CodeGDSStaatenTyp3;
import de.muenchen.xjustiz.generated.TypeGDSAktenzeichen;
import de.muenchen.xjustiz.generated.TypeGDSAnschrift;
import de.muenchen.xjustiz.generated.TypeGDSBankverbindung;
import de.muenchen.xjustiz.generated.TypeGDSBehoerde;
import de.muenchen.xjustiz.generated.TypeGDSBeteiligter;
import de.muenchen.xjustiz.generated.TypeGDSBeteiligung;
import de.muenchen.xjustiz.generated.TypeGDSGeburt;
import de.muenchen.xjustiz.generated.TypeGDSGrunddaten;
import de.muenchen.xjustiz.generated.TypeGDSInstanzdaten;
import de.muenchen.xjustiz.generated.TypeGDSNameNatuerlichePerson;
import de.muenchen.xjustiz.generated.TypeGDSNatuerlichePerson;
import de.muenchen.xjustiz.generated.TypeGDSOrganisation;
import de.muenchen.xjustiz.generated.TypeGDSOrtsangabe;
import de.muenchen.xjustiz.generated.TypeGDSRefBeteiligtennummer;
import de.muenchen.xjustiz.xjustiz0500straf.builder.Builder;
import de.muenchen.xjustiz.xjustiz0500straf.builder.IncrementCounters;
import de.muenchen.xjustiz.xjustiz0500straf.config.NachrichtenProperty;
import de.muenchen.xjustiz.xjustiz0500straf.content.GrunddatenContent;
import de.muenchen.xjustiz.xjustiz0500straf.content.grunddaten.verfahrensdaten.beteiligung.Anschrift;
import de.muenchen.xjustiz.xjustiz0500straf.content.grunddaten.verfahrensdaten.beteiligung.Beteiligter;
import de.muenchen.xjustiz.xjustiz0500straf.content.grunddaten.verfahrensdaten.beteiligung.Beteiligung;
import de.muenchen.xjustiz.xjustiz0500straf.content.grunddaten.verfahrensdaten.beteiligung.Rolle;
import de.muenchen.xjustiz.xjustiz0500straf.content.grunddaten.verfahrensdaten.instanzdaten.Aktenzeichen;
import de.muenchen.xjustiz.xoev.XJustizProperty;
import de.muenchen.xjustiz.xoev.codelisten.XoevCodeGDS;
import de.muenchen.xjustiz.xoev.codelisten.XoevCodeGDSAnschriftstypen;
import de.muenchen.xjustiz.xoev.codelisten.XoevCodeGDSGerichteTyp3;
import de.muenchen.xjustiz.xoev.codelisten.XoevCodeGDSRollenbezeichnungTyp3;
import de.muenchen.xjustiz.xoev.codelisten.XoevCodeGDSSachgebietTyp3;
import org.springframework.stereotype.Component;

@Component
public class GrunddatenBuilder
extends Builder {
    private final IncrementCounters incrementCounters = new IncrementCounters();

    public GrunddatenBuilder(XJustizProperty xjustizProperty, NachrichtenProperty nachrichtenProperty) {
        super(xjustizProperty, nachrichtenProperty);
    }

    public TypeGDSGrunddaten build(GrunddatenContent grunddatenContent) {
        this.incrementCounters.reset();
        if (this.nachrichtenProperty.isOrganisationConfiguredInApplicationProperties()) {
            grunddatenContent.getBeteiligungen().ifPresent(b -> b.add(this.createApplicant()));
        }
        TypeGDSGrunddaten grunddaten = new TypeGDSGrunddaten();
        TypeGDSGrunddaten.Verfahrensdaten verfahrensdaten = new TypeGDSGrunddaten.Verfahrensdaten();
        grunddatenContent.getInstanzdaten().ifPresent(instanzen -> instanzen.forEach((type, fileNumber) -> {
            switch (type) {
                case BETEILIGTER: {
                    GrunddatenBuilder.handleBeteiligter(fileNumber, verfahrensdaten);
                    break;
                }
                case GERICHT: {
                    this.handleGericht((Aktenzeichen)fileNumber, verfahrensdaten);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown instance type: " + String.valueOf(type));
                }
            }
        }));
        grunddaten.setVerfahrensdaten(verfahrensdaten);
        grunddatenContent.getBeteiligungen().ifPresent(beteiligungen -> beteiligungen.forEach(beteiligung -> verfahrensdaten.getBeteiligung().add(this.beteiligungBuilder((Beteiligung)beteiligung))));
        return grunddaten;
    }

    private void handleGericht(Aktenzeichen fileNumber, TypeGDSGrunddaten.Verfahrensdaten verfahrensdaten) {
        TypeGDSInstanzdaten instanzGericht = new TypeGDSInstanzdaten();
        TypeGDSBehoerde behoerde = new TypeGDSBehoerde();
        instanzGericht.setInstanznummer("1");
        instanzGericht.setAuswahlInstanzbehoerde(behoerde);
        instanzGericht.setSachgebiet((CodeGDSSachgebietTyp3)this.createCodeGDSClass(XoevCodeGDS.CODE_GDS_SACHGEBIET_TYP_3, XoevCodeGDSSachgebietTyp3.OWI_SACHEN.getDescriptor()));
        instanzGericht.getAuswahlInstanzbehoerde().setGericht((CodeGDSGerichteTyp3)this.createCodeGDSClass(XoevCodeGDS.CODE_GDS_GERICHTE_TYP_3, XoevCodeGDSGerichteTyp3.AMTSGERICHT_MUENCHEN.getDescriptor()));
        TypeGDSAktenzeichen aktenzeichen = new TypeGDSAktenzeichen();
        TypeGDSAktenzeichen.AuswahlAktenzeichen auswahlAktenzeichen = new TypeGDSAktenzeichen.AuswahlAktenzeichen();
        auswahlAktenzeichen.setAktenzeichenFreitext(fileNumber.getFreitext());
        aktenzeichen.setAuswahlAktenzeichen(auswahlAktenzeichen);
        instanzGericht.setAktenzeichen(aktenzeichen);
        verfahrensdaten.getInstanzdaten().add(instanzGericht);
    }

    private static void handleBeteiligter(Aktenzeichen fileNumber, TypeGDSGrunddaten.Verfahrensdaten verfahrensdaten) {
        TypeGDSInstanzdaten instanzSachgebietBeteiligter = new TypeGDSInstanzdaten();
        instanzSachgebietBeteiligter.setInstanznummer("0");
        TypeGDSBehoerde abteilung = new TypeGDSBehoerde();
        TypeGDSRefBeteiligtennummer beteiligtenNummer = new TypeGDSRefBeteiligtennummer();
        beteiligtenNummer.setRefBeteiligtennummer("2");
        abteilung.setBeteiligter(beteiligtenNummer);
        instanzSachgebietBeteiligter.setAuswahlInstanzbehoerde(abteilung);
        TypeGDSAktenzeichen aktenzeichen = new TypeGDSAktenzeichen();
        TypeGDSAktenzeichen.AuswahlAktenzeichen auswahlAktenzeichen = new TypeGDSAktenzeichen.AuswahlAktenzeichen();
        auswahlAktenzeichen.setAktenzeichenFreitext(fileNumber.getFreitext());
        aktenzeichen.setAuswahlAktenzeichen(auswahlAktenzeichen);
        instanzSachgebietBeteiligter.setAktenzeichen(aktenzeichen);
        verfahrensdaten.getInstanzdaten().add(instanzSachgebietBeteiligter);
    }

    private TypeGDSBeteiligung beteiligungBuilder(Beteiligung beteiligungContent) {
        TypeGDSBeteiligung xjustizBeteiligung = new TypeGDSBeteiligung();
        beteiligungContent.getRollen().ifPresent(rollen -> rollen.forEach(r -> {
            TypeGDSBeteiligung.Rolle rolle = new TypeGDSBeteiligung.Rolle();
            rolle.setRollennummer(String.valueOf(this.incrementCounters.incrementEntireXmlRollennummer()));
            rolle.setNr(this.incrementCounters.incrementRollenbezeichnungCounter(r.getRollenbezeichnung()));
            rolle.setRollenbezeichnung((CodeGDSRollenbezeichnungTyp3)this.createCodeGDSClass(XoevCodeGDS.CODE_GDS_ROLLENBEZEICHNUNG_TYP_3, r.getRollenbezeichnung()));
            xjustizBeteiligung.getRolle().add(rolle);
        }));
        beteiligungContent.getBeteiligter().ifPresent(b -> {
            if (b.getOrganisation().isPresent()) {
                xjustizBeteiligung.setBeteiligter(this.beteiligteOrganisation((Beteiligter)b));
            } else {
                xjustizBeteiligung.setBeteiligter(this.beteiligtePerson((Beteiligter)b));
            }
        });
        return xjustizBeteiligung;
    }

    private TypeGDSBeteiligter beteiligteOrganisation(Beteiligter b) {
        TypeGDSBeteiligter beteiligter = new TypeGDSBeteiligter();
        beteiligter.setBeteiligtennummer(String.valueOf(this.incrementCounters.incrementBeteiligtenNummer()));
        b.getOrganisation().ifPresent(o -> {
            TypeGDSOrganisation organisation = new TypeGDSOrganisation();
            beteiligter.setAuswahlBeteiligter(new TypeGDSBeteiligter.AuswahlBeteiligter());
            TypeGDSOrganisation.Bezeichnung bezeichnung = new TypeGDSOrganisation.Bezeichnung();
            bezeichnung.setBezeichnungAktuell(o.getBezeichnungAktuell());
            organisation.setBezeichnung(bezeichnung);
            o.getAnschriftenList().ifPresent(anschriften -> anschriften.forEach(a -> {
                TypeGDSAnschrift anschrift = new TypeGDSAnschrift();
                anschrift.setAnschriftstyp((CodeGDSAnschriftstyp)this.createCodeGDSClass(XoevCodeGDS.CODE_GDS_ANSCHRIFTSTYP, a.getAnschriftstyp()));
                anschrift.setStrasse(a.getStrasse());
                anschrift.setHausnummer(a.getHausnummer());
                anschrift.setPostleitzahl(a.getPlz());
                anschrift.setOrt(a.getOrt());
                organisation.getAnschrift().add(anschrift);
            }));
            TypeGDSBankverbindung bankverbindung = new TypeGDSBankverbindung();
            bankverbindung.setIban(o.getIban());
            organisation.getBankverbindung().add(bankverbindung);
            beteiligter.getAuswahlBeteiligter().setOrganisation(organisation);
        });
        return beteiligter.getAuswahlBeteiligter() != null ? beteiligter : null;
    }

    private TypeGDSBeteiligter beteiligtePerson(Beteiligter b) {
        TypeGDSBeteiligter beteiligter = new TypeGDSBeteiligter();
        beteiligter.setBeteiligtennummer(String.valueOf(this.incrementCounters.incrementBeteiligtenNummer()));
        b.getNatuerlichePerson().ifPresent(p -> {
            beteiligter.setAuswahlBeteiligter(new TypeGDSBeteiligter.AuswahlBeteiligter());
            TypeGDSNatuerlichePerson person = new TypeGDSNatuerlichePerson();
            p.getVollerName().ifPresent(vn -> {
                TypeGDSNameNatuerlichePerson name = new TypeGDSNameNatuerlichePerson();
                name.setVorname(vn.getVorname());
                name.setNachname(vn.getNachname());
                name.setTitel(vn.getTitel());
                name.setNamensvorsatz(vn.getNamensvorsatz());
                name.setGeburtsname(vn.getGeburtsname());
                person.setVollerName(name);
            });
            p.getGeburt().ifPresent(g -> {
                TypeGDSGeburt geburt = new TypeGDSGeburt();
                geburt.setGeburtsdatum(g.getGeburtsdatum());
                TypeGDSOrtsangabe ortsangabe = new TypeGDSOrtsangabe();
                ortsangabe.setOrt(g.getGeburtsort());
                geburt.setGeburtsort(ortsangabe);
                person.setGeburt(geburt);
            });
            p.getGeschlecht().ifPresent(g -> {
                CodeGDSGeschlecht geschlecht = new CodeGDSGeschlecht();
                geschlecht.setCode(g.getDescriptor());
                person.setGeschlecht(geschlecht);
            });
            p.getAnschriftenList().ifPresent(anschriften -> anschriften.forEach(a -> {
                TypeGDSAnschrift anschrift = new TypeGDSAnschrift();
                anschrift.setPostfachnummer(a.getPostfachnummer());
                anschrift.setStrasse(a.getStrasse());
                anschrift.setHausnummer(a.getHausnummer());
                anschrift.setPostleitzahl(a.getPlz());
                anschrift.setOrt(a.getOrt());
                anschrift.setWohnungsgeber(a.getWohnungsgeber());
                anschrift.setStaat((CodeGDSStaatenTyp3)this.createCodeGDSClass(XoevCodeGDS.CODE_GDS_STAATEN_TYP_3, a.getStaat()));
                anschrift.getAnschriftenzusatz().add(a.getAnschriftenzusatz());
                person.getAnschrift().add(anschrift);
            }));
            beteiligter.getAuswahlBeteiligter().setNatuerlichePerson(person);
        });
        return beteiligter.getAuswahlBeteiligter() != null ? beteiligter : null;
    }

    private Beteiligung createApplicant() {
        Beteiligung beteiligung = new Beteiligung();
        Rolle rolle = new Rolle();
        rolle.setRollenbezeichnung(XoevCodeGDSRollenbezeichnungTyp3.BUSSGELDEMPFAENGER.getDescriptor());
        beteiligung.addRolle(rolle);
        beteiligung.generateBeteiligter().generateOrganisation().setBezeichnungAktuell(this.nachrichtenProperty.getGrunddaten().getVerfahrensdaten().getBeteiligung().getOrganisation().getBezeichnungAktuell());
        Anschrift anschrift = new Anschrift();
        anschrift.setStrasse(this.nachrichtenProperty.getGrunddaten().getVerfahrensdaten().getBeteiligung().getOrganisation().getBezeichnungAnschriftStrasse());
        anschrift.setHausnummer(this.nachrichtenProperty.getGrunddaten().getVerfahrensdaten().getBeteiligung().getOrganisation().getBezeichnungAnschriftHausnummer());
        anschrift.setPlz(this.nachrichtenProperty.getGrunddaten().getVerfahrensdaten().getBeteiligung().getOrganisation().getBezeichnungAnschriftPlz());
        anschrift.setOrt(this.nachrichtenProperty.getGrunddaten().getVerfahrensdaten().getBeteiligung().getOrganisation().getBezeichnungAnschriftOrt());
        anschrift.setAnschriftstyp(XoevCodeGDSAnschriftstypen.DIENST_GESCHAEFTSANSCHRIFT.getDescriptor());
        beteiligung.generateBeteiligter().generateOrganisation().addAnschrift(anschrift);
        beteiligung.generateBeteiligter().generateOrganisation().setIban(this.nachrichtenProperty.getGrunddaten().getVerfahrensdaten().getBeteiligung().getOrganisation().getBezeichnungBankverbindung());
        return beteiligung;
    }
}

