/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.mobidam.eai.common.s3;

import de.muenchen.mobidam.eai.common.config.EnvironmentReader;
import de.muenchen.mobidam.eai.common.config.S3BucketCredentialConfig;
import de.muenchen.mobidam.eai.common.exception.ErrorResponseBuilder;
import de.muenchen.mobidam.eai.common.exception.MobidamException;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.tooling.model.Strings;

public class S3CredentialProvider
implements Processor {
    private static final String TENANT_CONFIG = "tenant-default";
    @NonNull
    private final S3BucketCredentialConfig properties;
    private final EnvironmentReader environmentReader;

    public void process(Exchange exchange) throws Exception {
        String bucketName = this.verifyBucket(exchange);
        S3BucketCredentialConfig.BucketCredentialConfig credentials = this.verifyCredentials(bucketName, exchange);
        String accessKey = this.environmentReader.getEnvironmentVariable(credentials.getAccessKeyEnvVar());
        String secretKey = this.environmentReader.getEnvironmentVariable(credentials.getSecretKeyEnvVar());
        if (Strings.isNullOrEmpty((String)accessKey) || Strings.isNullOrEmpty((String)secretKey)) {
            exchange.getMessage().setBody((Object)ErrorResponseBuilder.build(500, "Bucket not configured: " + bucketName));
            throw new MobidamException("Bucket not configured: " + bucketName);
        }
        exchange.getMessage().setHeader("accessKey", (Object)accessKey);
        exchange.getMessage().setHeader("secretKey", (Object)secretKey);
    }

    private String verifyBucket(Exchange exchange) throws MobidamException {
        String bucketName = (String)exchange.getMessage().getHeader("bucketName", String.class);
        if (Strings.isNullOrEmpty((String)bucketName)) {
            exchange.getMessage().setBody((Object)ErrorResponseBuilder.build(400, "Bucket name is missing"));
            throw new MobidamException("Bucket name is missing");
        }
        return bucketName;
    }

    private S3BucketCredentialConfig.BucketCredentialConfig verifyCredentials(String bucketName, Exchange exchange) throws MobidamException {
        Map<String, S3BucketCredentialConfig.BucketCredentialConfig> map = this.properties.getBucketCredentialConfigs();
        S3BucketCredentialConfig.BucketCredentialConfig envVars = map.get(bucketName);
        if (envVars == null && (envVars = map.get(TENANT_CONFIG)) == null) {
            exchange.getMessage().setBody((Object)ErrorResponseBuilder.build(500, "Configuration for bucket and tenant not found: " + bucketName));
            throw new MobidamException("Configuration for bucket and tenant not found: " + bucketName);
        }
        return envVars;
    }

    @Generated
    public S3CredentialProvider(@NonNull S3BucketCredentialConfig properties, EnvironmentReader environmentReader) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.properties = properties;
        this.environmentReader = environmentReader;
    }
}

