/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.oss.ad2image.starter.core;

import com.talanlabs.avatargenerator.Avatar;
import com.talanlabs.avatargenerator.GitHubAvatar;
import com.talanlabs.avatargenerator.IdenticonAvatar;
import com.talanlabs.avatargenerator.SquareAvatar;
import com.talanlabs.avatargenerator.TriangleAvatar;
import de.muenchen.oss.ad2image.starter.core.AdConfigurationProperties;
import de.muenchen.oss.ad2image.starter.core.ExchangeConfigurationProperties;
import de.muenchen.oss.ad2image.starter.core.ImageSize;
import de.muenchen.oss.ad2image.starter.core.Mode;
import de.muenchen.oss.ad2image.starter.core.User;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.core.io.ClassPathResource;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.ldap.support.LdapEncoder;
import org.springframework.util.StreamUtils;

public class AvatarLoader {
    private static final Logger log = LoggerFactory.getLogger(AvatarLoader.class);
    private final LdapTemplate ldapTemplate;
    private final CloseableHttpClient httpClient;
    private final String exchangeBaseUrl;
    private final AdConfigurationProperties adConfigurationProps;
    private final Map<ImageSize, Avatar> identiconAvatarBuilders;
    private final Map<ImageSize, Avatar> triangleAvatarBuilders;
    private final Map<ImageSize, Avatar> squareAvatarBuilders;
    private final Map<ImageSize, Avatar> githubAvatarBuilders;

    public AvatarLoader(LdapTemplate ldapTemplate, RestTemplateBuilder restTemplateBuilder, AdConfigurationProperties adConfigurationProps, ExchangeConfigurationProperties exchangeConfigurationProps) {
        log.debug("Initializing AvatarLoader instance...");
        this.adConfigurationProps = adConfigurationProps;
        this.ldapTemplate = ldapTemplate;
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(null, -1), (Credentials)new NTCredentials(exchangeConfigurationProps.getUsername(), exchangeConfigurationProps.getPassword().toCharArray(), "ad2image", exchangeConfigurationProps.getDomain()));
        this.httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        this.exchangeBaseUrl = exchangeConfigurationProps.getEwsServiceUrl();
        this.identiconAvatarBuilders = this.buildAvatarBuilders(IdenticonAvatar.newAvatarBuilder());
        this.triangleAvatarBuilders = this.buildAvatarBuilders(TriangleAvatar.newAvatarBuilder());
        this.squareAvatarBuilders = this.buildAvatarBuilders(SquareAvatar.newAvatarBuilder());
        this.githubAvatarBuilders = this.buildAvatarBuilders(GitHubAvatar.newAvatarBuilder());
        log.debug("Initialized AvatarLoader instance.");
    }

    private Map<ImageSize, Avatar> buildAvatarBuilders(Avatar.AvatarBuilder avatarBuilder) {
        EnumMap<ImageSize, Avatar> avatarBuilders = new EnumMap<ImageSize, Avatar>(ImageSize.class);
        for (ImageSize size : ImageSize.values()) {
            avatarBuilders.put(size, avatarBuilder.size(size.getSizePixels(), size.getSizePixels()).build());
        }
        return avatarBuilders;
    }

    public byte[] loadAvatar(String uid, Mode mode, ImageSize size) {
        log.info("Looking up '{}' in AD (mode='{}', size='{}')...", new Object[]{uid, mode, size});
        List<User> users = this.findPersonInAD(uid);
        if (users.size() == 1) {
            User user = users.get(0);
            if (user.getThumbnailPhoto() != null) {
                if (size.equals((Object)ImageSize.getAdDefaultImageSize())) {
                    log.debug("Using AD thumbnailPhoto as avatar for '{}'.", (Object)uid);
                    return users.get(0).getThumbnailPhoto();
                }
                log.debug("Calling Exchange EWS API GetUserPhoto for '{}' with size '{}'.", (Object)uid, (Object)size);
                return this.getUserPhotoFromExchange(user.getEmail(), size.getSizeRequestedValue());
            }
            return this.generateFallbackAvatar(uid, mode, size);
        }
        return this.generateFallbackAvatar(uid, mode, size);
    }

    private byte[] getUserPhotoFromExchange(String email, String size) {
        String url = this.exchangeBaseUrl + "/s/GetUserPhoto?email=" + email + "&size=" + size;
        HttpGet httpGet = new HttpGet(url);
        try {
            return (byte[])this.httpClient.execute((ClassicHttpRequest)httpGet, response -> {
                if (response.getCode() == 200) {
                    return EntityUtils.toByteArray((HttpEntity)response.getEntity());
                }
                log.warn("Failed to retrieve user photo from Exchange, HTTP status code: {}", (Object)response.getCode());
                return null;
            });
        }
        catch (IOException e) {
            log.error("Exception while fetching user photo from Exchange.", (Throwable)e);
            return null;
        }
    }

    private byte[] generateFallbackAvatar(String uid, Mode mode, ImageSize size) {
        switch (mode) {
            case M_IDENTICON: 
            case M_FALLBACK_IDENTICON: {
                log.debug("Generating identicon fallback avatar for '{}'.", (Object)uid);
                return this.identiconAvatarBuilders.get((Object)size).createAsPngBytes((long)uid.hashCode());
            }
            case M_GENERIC: 
            case M_FALLBACK_GENERIC: {
                log.debug("Using generic fallback avatar for '{}'.", (Object)uid);
                return this.getGenericPhoto(size);
            }
            case M_TRIANGLE: 
            case M_FALLBACK_TRIANGLE: {
                log.debug("Generating triangle fallback avatar for '{}'.", (Object)uid);
                return this.triangleAvatarBuilders.get((Object)size).createAsPngBytes((long)uid.hashCode());
            }
            case M_SQUARE: 
            case M_FALLBACK_SQUARE: {
                log.debug("Generating square fallback avatar for '{}'.", (Object)uid);
                return this.squareAvatarBuilders.get((Object)size).createAsPngBytes((long)uid.hashCode());
            }
            case M_GITHUB: 
            case M_FALLBACK_GITHUB: {
                log.debug("Generating github fallback avatar for '{}'.", (Object)uid);
                return this.githubAvatarBuilders.get((Object)size).createAsPngBytes((long)uid.hashCode());
            }
        }
        log.debug("No thumbnailPhoto for '{}' found and no fallback specified - returning null.", (Object)uid);
        return null;
    }

    private List<User> findPersonInAD(String uid) {
        String userSearchFilter = this.adConfigurationProps.getUserSearchFilter();
        String safeUid = LdapEncoder.filterEncode((String)uid);
        String finalFilter = userSearchFilter.replace("{uid}", safeUid);
        final String uidAttribute = this.adConfigurationProps.getUidAttribute();
        final String mailAttribute = this.adConfigurationProps.getMailAttribute();
        final String thumbnailPhotoAttribute = this.adConfigurationProps.getThumbnailPhotoAttribute();
        return this.ldapTemplate.search(LdapQueryBuilder.query().base(this.adConfigurationProps.getUserSearchBase()).filter(finalFilter), (AttributesMapper)new AttributesMapper<User>(){

            public User mapFromAttributes(Attributes attributes) throws NamingException {
                User u = new User();
                u.setUid((String)attributes.get(uidAttribute).get());
                u.setEmail((String)attributes.get(mailAttribute).get());
                Attribute thumbnailAttribute = attributes.get(thumbnailPhotoAttribute);
                if (thumbnailAttribute != null) {
                    u.setThumbnailPhoto((byte[])thumbnailAttribute.get());
                }
                return u;
            }
        });
    }

    private byte[] getGenericPhoto(ImageSize size) {
        try {
            return StreamUtils.copyToByteArray((InputStream)new ClassPathResource("account_" + size.getSizePixels() + ".png").getInputStream());
        }
        catch (IOException e) {
            log.error("IOException while reading generic image.", (Throwable)e);
            throw new RuntimeException("IOException while reading generic image.", e);
        }
    }
}

