/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.oss.ad2image.starter.spring;

import de.muenchen.oss.ad2image.starter.core.Ad2ImageConfigurationProperties;
import de.muenchen.oss.ad2image.starter.core.AdConfigurationProperties;
import de.muenchen.oss.ad2image.starter.core.AvatarLoader;
import de.muenchen.oss.ad2image.starter.core.ExchangeConfigurationProperties;
import de.muenchen.oss.ad2image.starter.spring.AvatarController;
import de.muenchen.oss.ad2image.starter.spring.AvatarService;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;

@AutoConfiguration
@ConditionalOnProperty(value={"de.muenchen.oss.ad2image.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
public class Ad2ImageAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    AvatarService avatarService(AvatarLoader avatarLoader) {
        return new AvatarService(avatarLoader);
    }

    @Bean
    @ConditionalOnMissingBean
    AvatarLoader avatarLoader(@Qualifier(value="ad2ImageLdapTemplate") LdapTemplate ad2ImageLdapTemplate, RestTemplateBuilder restTemplateBuilder, Ad2ImageConfigurationProperties ad2ImageProps) {
        return new AvatarLoader(ad2ImageLdapTemplate, restTemplateBuilder, ad2ImageProps.getAd(), ad2ImageProps.getEws());
    }

    @Bean
    @ConditionalOnMissingBean
    AvatarController avatarController(AvatarService service) {
        return new AvatarController(service);
    }

    @Bean(value={"ad2ImageLdapTemplate"})
    @ConditionalOnMissingBean(name={"ad2ImageLdapTemplate"})
    LdapTemplate ad2ImageLdapTemplate(@Qualifier(value="ad2ImageLdapContextSource") LdapContextSource ad2ImageLdapContextSource) {
        return new LdapTemplate((ContextSource)ad2ImageLdapContextSource);
    }

    @Bean(value={"ad2ImageLdapContextSource"})
    @ConditionalOnMissingBean(name={"ad2ImageLdapContextSource"})
    LdapContextSource ad2ImageLdapContextSource(AdConfigurationProperties adConfProps) {
        LdapContextSource ldapContextSource = new LdapContextSource();
        ldapContextSource.setUrl(adConfProps.getUrl());
        ldapContextSource.setUserDn(adConfProps.getUserDn());
        ldapContextSource.setPassword(adConfProps.getPassword());
        return ldapContextSource;
    }

    @Configuration
    @EnableConfigurationProperties(value={Ad2ImageConfigurationProperties.class, ExchangeConfigurationProperties.class, AdConfigurationProperties.class})
    static class ConfigPropertiesConfiguration {
        ConfigPropertiesConfiguration() {
        }
    }
}

