/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.oss.ad2image.starter.core;

import com.talanlabs.avatargenerator.Avatar;
import com.talanlabs.avatargenerator.GitHubAvatar;
import com.talanlabs.avatargenerator.IdenticonAvatar;
import com.talanlabs.avatargenerator.SquareAvatar;
import com.talanlabs.avatargenerator.TriangleAvatar;
import de.muenchen.oss.ad2image.starter.core.AdConfigurationProperties;
import de.muenchen.oss.ad2image.starter.core.ExchangeConfigurationProperties;
import de.muenchen.oss.ad2image.starter.core.ImageSize;
import de.muenchen.oss.ad2image.starter.core.User;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.ldap.support.LdapEncoder;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;
import org.springframework.web.client.RestTemplate;

public class AvatarLoader {
    public static final String MODE_404 = "404";
    public static final String MODE_IDENTICON = "identicon";
    public static final String MODE_FALLBACK_IDENTICON = "fallbackIdenticon";
    public static final String MODE_GENERIC = "generic";
    public static final String MODE_FALLBACK_GENERIC = "fallbackGeneric";
    public static final String MODE_TRIANGLE = "triangle";
    public static final String MODE_FALLBACK_TRIANGLE = "fallbackTriangle";
    public static final String MODE_SQUARE = "square";
    public static final String MODE_FALLBACK_SQUARE = "fallbackSquare";
    public static final String MODE_GITHUB = "github";
    public static final String MODE_FALLBACK_GITHUB = "fallbackGithub";
    private static final Logger log = LoggerFactory.getLogger(AvatarLoader.class);
    private final LdapTemplate ldapTemplate;
    private final RestTemplate restTemplate;
    private final String exchangeBaseUrl;
    private final AdConfigurationProperties adConfigurationProps;
    private final Map<ImageSize, Avatar> identiconAvatarBuilders;
    private final Map<ImageSize, Avatar> triangleAvatarBuilders;
    private final Map<ImageSize, Avatar> squareAvatarBuilders;
    private final Map<ImageSize, Avatar> githubAvatarBuilders;

    public AvatarLoader(LdapTemplate ldapTemplate, RestTemplateBuilder restTemplateBuilder, AdConfigurationProperties adConfigurationProps, ExchangeConfigurationProperties exchangeConfigurationProps) {
        log.debug("Initializing AvatarLoader instance...");
        this.adConfigurationProps = adConfigurationProps;
        this.ldapTemplate = ldapTemplate;
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(null, -1), (Credentials)new NTCredentials(exchangeConfigurationProps.getUsername(), exchangeConfigurationProps.getPassword().toCharArray(), "ad2image", exchangeConfigurationProps.getDomain()));
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setHttpClient((HttpClient)httpClient);
        this.restTemplate = restTemplateBuilder.build();
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        this.exchangeBaseUrl = exchangeConfigurationProps.getEwsServiceUrl();
        this.identiconAvatarBuilders = this.buildAvatarBuilders(IdenticonAvatar.newAvatarBuilder());
        this.triangleAvatarBuilders = this.buildAvatarBuilders(TriangleAvatar.newAvatarBuilder());
        this.squareAvatarBuilders = this.buildAvatarBuilders(SquareAvatar.newAvatarBuilder());
        this.githubAvatarBuilders = this.buildAvatarBuilders(GitHubAvatar.newAvatarBuilder());
        log.debug("Initialized AvatarLoader instance.");
    }

    private Map<ImageSize, Avatar> buildAvatarBuilders(Avatar.AvatarBuilder avatarBuilder) {
        EnumMap<ImageSize, Avatar> avatarBuilders = new EnumMap<ImageSize, Avatar>(ImageSize.class);
        for (ImageSize size : ImageSize.values()) {
            avatarBuilders.put(size, avatarBuilder.size(size.getSizePixels(), size.getSizePixels()).build());
        }
        return avatarBuilders;
    }

    public byte[] loadAvatar(String uid, String mode, ImageSize size) {
        log.info("Looking up '{}' in AD (mode='{}', size='{}')...", new Object[]{uid, mode, size});
        List<User> users = this.findPersonInAD(uid);
        if (users.size() == 1) {
            User user = users.get(0);
            if (user.getThumbnailPhoto() != null) {
                if (size.equals((Object)ImageSize.getAdDefaultImageSize())) {
                    log.debug("Using AD thumbnailPhoto as avatar for '{}'.", (Object)uid);
                    return users.get(0).getThumbnailPhoto();
                }
                log.debug("Calling Exchange EWS API GetUserPhoto for '{}' with size '{}'.", (Object)uid, (Object)size);
                ResponseEntity exchange = this.restTemplate.exchange(this.exchangeBaseUrl + "/s/GetUserPhoto?email={email}&size={size}", HttpMethod.GET, new HttpEntity((MultiValueMap)new HttpHeaders()), byte[].class, new Object[]{user.getEmail(), size.getSizeRequestedValue()});
                return (byte[])exchange.getBody();
            }
            switch (mode) {
                case "identicon": 
                case "fallbackIdenticon": {
                    log.debug("Generating identicon fallback avatar for '{}'.", (Object)uid);
                    return this.identiconAvatarBuilders.get((Object)size).createAsPngBytes((long)uid.hashCode());
                }
                case "generic": 
                case "fallbackGeneric": {
                    log.debug("Using generic fallback avatar for '{}'.", (Object)uid);
                    return this.getGenericPhoto(size);
                }
                case "triangle": 
                case "fallbackTriangle": {
                    log.debug("Generating triangle fallback avatar for '{}'.", (Object)uid);
                    return this.triangleAvatarBuilders.get((Object)size).createAsPngBytes((long)uid.hashCode());
                }
                case "square": 
                case "fallbackSquare": {
                    log.debug("Generating square fallback avatar for '{}'.", (Object)uid);
                    return this.squareAvatarBuilders.get((Object)size).createAsPngBytes((long)uid.hashCode());
                }
                case "github": 
                case "fallbackGithub": {
                    log.debug("Generating github fallback avatar for '{}'.", (Object)uid);
                    return this.githubAvatarBuilders.get((Object)size).createAsPngBytes((long)uid.hashCode());
                }
            }
            log.debug("No thumbnailPhoto for '{}' found and no fallback specified - returning null.", (Object)uid);
            return null;
        }
        switch (mode) {
            case "fallbackIdenticon": {
                log.debug("Generating identicon for non AD-Username '{}'.", (Object)uid);
                return this.identiconAvatarBuilders.get((Object)size).createAsPngBytes((long)uid.hashCode());
            }
            case "fallbackGeneric": {
                log.debug("Using generic photo for non AD-Username '{}'.", (Object)uid);
                return this.getGenericPhoto(size);
            }
            case "fallbackTriangle": {
                log.debug("Generating triangle-Avatar for non AD-Username '{}'.", (Object)uid);
                return this.triangleAvatarBuilders.get((Object)size).createAsPngBytes((long)uid.hashCode());
            }
            case "fallbackSquare": {
                log.debug("Generating square-Avatar for non AD-Username '{}'.", (Object)uid);
                return this.squareAvatarBuilders.get((Object)size).createAsPngBytes((long)uid.hashCode());
            }
            case "fallbackGithub": {
                log.debug("Generating github-Avatar for non AD-Username '{}'.", (Object)uid);
                return this.githubAvatarBuilders.get((Object)size).createAsPngBytes((long)uid.hashCode());
            }
        }
        log.warn("UID '{}' doesn't exist.", (Object)uid);
        return null;
    }

    private List<User> findPersonInAD(String uid) {
        String userSearchFilter = this.adConfigurationProps.getUserSearchFilter();
        String safeUid = LdapEncoder.filterEncode((String)uid);
        String finalFilter = userSearchFilter.replace("{uid}", safeUid);
        final String uidAttribute = this.adConfigurationProps.getUidAttribute();
        final String mailAttribute = this.adConfigurationProps.getMailAttribute();
        final String thumbnailPhotoAttribute = this.adConfigurationProps.getThumbnailPhotoAttribute();
        return this.ldapTemplate.search(LdapQueryBuilder.query().base(this.adConfigurationProps.getUserSearchBase()).filter(finalFilter), (AttributesMapper)new AttributesMapper<User>(){

            public User mapFromAttributes(Attributes attributes) throws NamingException {
                User u = new User();
                u.setUid((String)attributes.get(uidAttribute).get());
                u.setEmail((String)attributes.get(mailAttribute).get());
                Attribute thumbnailAttribute = attributes.get(thumbnailPhotoAttribute);
                if (thumbnailAttribute != null) {
                    u.setThumbnailPhoto((byte[])thumbnailAttribute.get());
                }
                return u;
            }
        });
    }

    private byte[] getGenericPhoto(ImageSize size) {
        try {
            return StreamUtils.copyToByteArray((InputStream)new ClassPathResource("account_" + size.getSizePixels() + ".png").getInputStream());
        }
        catch (IOException e) {
            log.error("IOException while reading generic image.", (Throwable)e);
            throw new RuntimeException("IOException while reading generic image.", e);
        }
    }
}

