/*
 * Decompiled with CFR 0.152.
 */
package de.mannodermaus.rxbonjour.model;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;

public class BonjourService {
    private String mName;
    private String mType;
    private Inet4Address mV4Host;
    private Inet6Address mV6Host;
    private int mPort;
    private Bundle mTxtRecords;

    private BonjourService(String name, String type, Inet4Address v4Host, Inet6Address v6Host, int port, Bundle txtRecords) {
        this.mName = name;
        this.mType = type;
        this.mV4Host = v4Host;
        this.mV6Host = v6Host;
        this.mPort = port;
        this.mTxtRecords = txtRecords;
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    @NonNull
    public String getType() {
        return this.mType;
    }

    @NonNull
    public InetAddress getHost() {
        return this.mV4Host != null ? this.mV4Host : this.mV6Host;
    }

    @Nullable
    public Inet4Address getV4Host() {
        return this.mV4Host;
    }

    @Nullable
    public Inet6Address getV6Host() {
        return this.mV6Host;
    }

    public int getPort() {
        return this.mPort;
    }

    public int getTxtRecordCount() {
        return this.mTxtRecords.size();
    }

    @NonNull
    public Bundle getTxtRecords() {
        return this.mTxtRecords;
    }

    public String getTxtRecord(String key, String defaultValue) {
        String value = this.mTxtRecords.getString(key);
        return value != null ? value : defaultValue;
    }

    @Nullable
    public String getTxtRecord(String key) {
        return this.getTxtRecord(key, null);
    }

    public String toString() {
        return "BonjourService{name='" + this.mName + '\'' + ", type='" + this.mType + '\'' + ", v4Host=" + this.mV4Host + ", v6Host=" + this.mV6Host + ", port=" + this.mPort + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BonjourService)) {
            return false;
        }
        BonjourService that = (BonjourService)o;
        if (this.mPort != that.mPort) {
            return false;
        }
        if (!this.mName.equals(that.mName)) {
            return false;
        }
        if (!this.mType.equals(that.mType)) {
            return false;
        }
        if (this.mV4Host != null ? !this.mV4Host.equals(that.mV4Host) : that.mV4Host != null) {
            return false;
        }
        return !(this.mV6Host == null ? that.mV6Host != null : !this.mV6Host.equals(that.mV6Host));
    }

    public int hashCode() {
        int result = this.mName != null ? this.mName.hashCode() : 0;
        result = 31 * result + (this.mType != null ? this.mType.hashCode() : 0);
        result = 31 * result + (this.mV4Host != null ? this.mV4Host.hashCode() : 0);
        result = 31 * result + (this.mV6Host != null ? this.mV6Host.hashCode() : 0);
        result = 31 * result + this.mPort;
        return result;
    }

    public static final class Builder {
        private String mName;
        private String mType;
        private Inet4Address mHostv4;
        private Inet6Address mHostv6;
        private int mPort;
        private Bundle mTxtRecords;

        public Builder(String name, String type) {
            this.mName = name;
            this.mType = type;
        }

        public Builder addAddress(InetAddress address) {
            if (address instanceof Inet4Address) {
                this.mHostv4 = (Inet4Address)address;
            } else if (address instanceof Inet6Address) {
                this.mHostv6 = (Inet6Address)address;
            }
            return this;
        }

        public Builder setPort(int port) {
            this.mPort = port;
            return this;
        }

        public Builder addTxtRecord(String key, String value) {
            if (this.mTxtRecords == null) {
                this.mTxtRecords = new Bundle();
            }
            this.mTxtRecords.putString(key, value);
            return this;
        }

        public BonjourService build() {
            if (this.mTxtRecords == null) {
                this.mTxtRecords = new Bundle(0);
            }
            return new BonjourService(this.mName, this.mType, this.mHostv4, this.mHostv6, this.mPort, this.mTxtRecords);
        }
    }
}

