/*
 * Decompiled with CFR 0.152.
 */
package de.mannodermaus.rxbonjour.discovery;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.nsd.NsdManager;
import android.net.nsd.NsdServiceInfo;
import android.os.Build;
import de.mannodermaus.rxbonjour.discovery.BonjourDiscovery;
import de.mannodermaus.rxbonjour.exc.DiscoveryFailed;
import de.mannodermaus.rxbonjour.exc.StaleContextException;
import de.mannodermaus.rxbonjour.internal.Backlog;
import de.mannodermaus.rxbonjour.model.BonjourEvent;
import de.mannodermaus.rxbonjour.model.BonjourService;
import de.mannodermaus.rxbonjour.utils.JBUtils;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.Map;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.MainThreadSubscription;

@TargetApi(value=16)
final class JBBonjourDiscovery
extends BonjourDiscovery<JBUtils> {
    private int subscriberCount = 0;
    private Backlog<NsdServiceInfo> resolveBacklog;

    @Override
    protected JBUtils createUtils() {
        return JBUtils.get();
    }

    @TargetApi(value=21)
    private BonjourEvent newBonjourEvent(BonjourEvent.Type type, NsdServiceInfo serviceInfo) {
        BonjourService.Builder serviceBuilder = new BonjourService.Builder(serviceInfo.getServiceName(), serviceInfo.getServiceType());
        if (Build.VERSION.SDK_INT >= 21) {
            Map attributes = serviceInfo.getAttributes();
            for (String key : attributes.keySet()) {
                serviceBuilder.addTxtRecord(key, new String((byte[])attributes.get(key), Charset.forName("UTF-8")));
            }
        }
        serviceBuilder.addAddress(serviceInfo.getHost());
        serviceBuilder.setPort(serviceInfo.getPort());
        return new BonjourEvent(type, serviceBuilder.build());
    }

    @Override
    public Observable<BonjourEvent> start(Context context, final String type) {
        final WeakReference<Context> weakContext = new WeakReference<Context>(context);
        Observable obs = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<BonjourEvent>(){

            public void call(final Subscriber<? super BonjourEvent> subscriber) {
                NsdManager nsdManager;
                Context context = (Context)weakContext.get();
                if (context == null) {
                    subscriber.onError((Throwable)new StaleContextException());
                    return;
                }
                final NsdManager.DiscoveryListener discoveryListener = new NsdManager.DiscoveryListener(){

                    public void onStartDiscoveryFailed(String serviceType, int errorCode) {
                        subscriber.onError((Throwable)new DiscoveryFailed(JBBonjourDiscovery.class, serviceType, errorCode));
                    }

                    public void onStopDiscoveryFailed(String serviceType, int errorCode) {
                        subscriber.onError((Throwable)new DiscoveryFailed(JBBonjourDiscovery.class, serviceType, errorCode));
                    }

                    public void onDiscoveryStarted(String serviceType) {
                    }

                    public void onDiscoveryStopped(String serviceType) {
                    }

                    public void onServiceFound(NsdServiceInfo serviceInfo) {
                        JBBonjourDiscovery.this.resolveBacklog.add(serviceInfo);
                    }

                    public void onServiceLost(NsdServiceInfo serviceInfo) {
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onNext((Object)JBBonjourDiscovery.this.newBonjourEvent(BonjourEvent.Type.REMOVED, serviceInfo));
                        }
                    }
                };
                try {
                    nsdManager = ((JBUtils)JBBonjourDiscovery.this.utils).getManager(context);
                }
                catch (IOException e) {
                    if (subscriber.isUnsubscribed()) {
                        return;
                    }
                    subscriber.onError((Throwable)e);
                    return;
                }
                if (JBBonjourDiscovery.this.resolveBacklog == null) {
                    JBBonjourDiscovery.this.resolveBacklog = new Backlog<NsdServiceInfo>(){

                        @Override
                        public void onNext(Backlog<NsdServiceInfo> backlog, NsdServiceInfo info) {
                            nsdManager.resolveService(info, new NsdManager.ResolveListener(){

                                public void onResolveFailed(NsdServiceInfo serviceInfo, int errorCode) {
                                }

                                public void onServiceResolved(NsdServiceInfo serviceInfo) {
                                    if (!subscriber.isUnsubscribed()) {
                                        subscriber.onNext((Object)JBBonjourDiscovery.this.newBonjourEvent(BonjourEvent.Type.ADDED, serviceInfo));
                                    }
                                    JBBonjourDiscovery.this.resolveBacklog.proceed();
                                }
                            });
                        }
                    };
                }
                subscriber.add((Subscription)new MainThreadSubscription(){

                    protected void onUnsubscribe() {
                        try {
                            nsdManager.stopServiceDiscovery(discoveryListener);
                            JBBonjourDiscovery.this.subscriberCount--;
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            if (JBBonjourDiscovery.this.subscriberCount <= 0) {
                                JBBonjourDiscovery.this.resolveBacklog.quit();
                                JBBonjourDiscovery.this.resolveBacklog = null;
                            }
                        }
                    }
                });
                nsdManager.discoverServices(type, 1, discoveryListener);
                JBBonjourDiscovery.this.subscriberCount++;
            }
        });
        return obs.share();
    }
}

