/*
 * Decompiled with CFR 0.152.
 */
package de.mannodermaus.rxbonjour;

import android.content.Context;
import de.mannodermaus.rxbonjour.broadcast.BonjourBroadcast;
import de.mannodermaus.rxbonjour.broadcast.BonjourBroadcastBuilder;
import de.mannodermaus.rxbonjour.discovery.BonjourDiscovery;
import de.mannodermaus.rxbonjour.exc.TypeMalformedException;
import de.mannodermaus.rxbonjour.model.BonjourEvent;
import rx.Observable;

public final class RxBonjour {
    private static final String TYPE_PATTERN = "_[a-zA-Z0-9\\-_]+\\.(_tcp|_udp)(\\.[a-zA-Z0-9\\-]+\\.)?";

    private RxBonjour() {
        throw new AssertionError((Object)"no instances");
    }

    public static Observable<BonjourEvent> startDiscovery(Context context, String type) {
        return RxBonjour.newDiscovery(context, type);
    }

    public static Observable<BonjourEvent> startDiscovery(Context context, String type, boolean useNsdManager) {
        return RxBonjour.newDiscovery(context, type, useNsdManager);
    }

    public static Observable<BonjourEvent> newDiscovery(Context context, String type) {
        return RxBonjour.newDiscovery(context, type, false);
    }

    public static Observable<BonjourEvent> newDiscovery(Context context, String type, boolean forceNsdManager) {
        if (!RxBonjour.isBonjourType(type)) {
            throw new TypeMalformedException(type);
        }
        BonjourDiscovery discovery = BonjourDiscovery.get(forceNsdManager);
        return discovery.start(context, type);
    }

    public static BonjourBroadcastBuilder newBroadcast(String type) {
        return RxBonjour.newBroadcast(type, false);
    }

    public static BonjourBroadcastBuilder newBroadcast(String type, boolean forceNsdManager) {
        if (!RxBonjour.isBonjourType(type)) {
            throw new TypeMalformedException(type);
        }
        return BonjourBroadcast.newBuilder(type, forceNsdManager);
    }

    public static boolean isBonjourType(String type) {
        return type.matches(TYPE_PATTERN);
    }
}

