/*
 * Decompiled with CFR 0.152.
 */
package jflex.maven.plugin.jflex;

import com.google.common.base.Strings;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

class SpecInfo {
    final String className;
    final String packageName;
    final Set<File> includedFiles;

    SpecInfo(String className, @Nullable String packageName) {
        this(className, packageName, Collections.emptySet());
    }

    SpecInfo(String className, @Nullable String packageName, Set<File> includedFiles) {
        this.className = className;
        this.packageName = Strings.nullToEmpty((String)packageName);
        this.includedFiles = new HashSet<File>(includedFiles);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SpecInfo)) {
            return false;
        }
        SpecInfo other = (SpecInfo)obj;
        return Objects.equals(this.className, other.className) && Objects.equals(this.packageName, other.packageName) && Objects.equals(this.includedFiles, other.includedFiles);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.packageName, this.includedFiles);
    }

    String getOutputFilename() {
        String packageDir = this.packageName.replace('.', File.separatorChar);
        if (packageDir.length() > 0) {
            packageDir = packageDir + File.separatorChar;
        }
        return packageDir + this.className + ".java";
    }
}

