/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.serializer;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import org.apache.commons.lang.mutable.MutableInt;

public class TestClasses {
    static Person createPerson(String name, Person.Gender gender, String ... emailAddresses) {
        return TestClasses.createPerson(name, gender, (Integer)null, emailAddresses);
    }

    static Person createPerson(String name, Person.Gender gender, Integer age, String ... emailAddresses) {
        Person person = new Person();
        person.setName(name);
        person.setGender(gender);
        person.setAge(age);
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (int i = 0; i < emailAddresses.length; ++i) {
            String emailAddress = emailAddresses[i];
            props.put("email" + i, new Email(name, emailAddress));
        }
        person.setProps(props);
        return person;
    }

    static Person createPerson(String name, Person.Gender gender, Calendar dateOfBirth, String ... emailAddresses) {
        int age = dateOfBirth == null ? -1 : Calendar.getInstance().get(1) - dateOfBirth.get(1);
        Person result = TestClasses.createPerson(name, gender, age, emailAddresses);
        result.setDateOfBirth(dateOfBirth);
        return result;
    }

    static ClassWithoutDefaultConstructor createClassWithoutDefaultConstructor(String string) {
        return new ClassWithoutDefaultConstructor(string);
    }

    static PrivateClass createPrivateClass(String string) {
        PrivateClass result = new PrivateClass();
        result.foo = string;
        return result;
    }

    static SomeInterface createProxy() {
        return (SomeInterface)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{SomeInterface.class, Serializable.class}, (InvocationHandler)new MyInvocationHandler(SomeInterfaceImpl.class));
    }

    public static class Component {
        private final String _name;
        private final List<Component> _children = new ArrayList<Component>();
        private Component _parent;

        public Component(String name) {
            this._name = name;
        }

        public Component addChild(Component child) {
            child.setParent(this);
            this._children.add(child);
            return this;
        }

        public Component addChildren(Collection<Component> children) {
            for (Component child : children) {
                child.setParent(this);
                this._children.add(child);
            }
            return this;
        }

        private void setParent(Component parent) {
            this._parent = parent;
        }

        public String getName() {
            return this._name;
        }

        public String toString() {
            return "Component [_children=" + this._children + ", _name=" + this._name + ", _parent=" + this._parent + "]";
        }
    }

    public static class MyContainer
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int _int = 42;
        private long _long = 42L;
        private final boolean _boolean;
        private final Boolean _Boolean = Boolean.TRUE;
        private final Class<?> _Class = String.class;
        private String _String = "42";
        private final StringBuilder _StringBuilder;
        private final StringBuffer _StringBuffer = new StringBuffer("foo");
        private Long _Long = 42L;
        private Integer _Integer = 42;
        private Character _Character;
        private Byte _Byte;
        private Double _Double = 42.0;
        private Float _Float;
        private Short _Short = 42;
        private BigDecimal _BigDecimal;
        private AtomicInteger _AtomicInteger;
        private AtomicLong _AtomicLong;
        private MutableInt _MutableInt;
        private Integer[] _IntegerArray;
        private Date _Date;
        private Calendar _Calendar;
        private final Currency _Currency;
        private List<String> _ArrayList;
        private final Set<String> _HashSet;
        private final Map<String, Integer> _HashMap;
        private int[] _intArray;
        private long[] _longArray;
        private short[] _shortArray;
        private float[] _floatArray;
        private double[] _doubleArray;
        private byte[] _byteArray;
        private char[] _charArray;
        private String[] _StringArray;
        private Person[] _PersonArray;

        public MyContainer() {
            this._boolean = true;
            this._StringBuilder = new StringBuilder("foo");
            this._Character = Character.valueOf('c');
            this._Byte = "b".getBytes()[0];
            this._Float = Float.valueOf(42.0f);
            this._BigDecimal = new BigDecimal(42);
            this._AtomicInteger = new AtomicInteger(42);
            this._AtomicLong = new AtomicLong(42L);
            this._MutableInt = new MutableInt(42);
            this._IntegerArray = new Integer[]{42};
            this._Date = new Date(System.currentTimeMillis() - 10000L);
            this._Calendar = Calendar.getInstance();
            this._Currency = Currency.getInstance("EUR");
            this._ArrayList = new ArrayList<String>(Arrays.asList("foo"));
            this._HashSet = new HashSet<String>();
            this._HashSet.add("42");
            this._HashMap = new HashMap<String, Integer>();
            this._HashMap.put("foo", 23);
            this._HashMap.put("bar", 42);
            this._intArray = new int[]{1, 2};
            this._longArray = new long[]{1L, 2L};
            this._shortArray = new short[]{1, 2};
            this._floatArray = new float[]{1.0f, 2.0f};
            this._doubleArray = new double[]{1.0, 2.0};
            this._byteArray = "42".getBytes();
            this._charArray = "42".toCharArray();
            this._StringArray = new String[]{"23", "42"};
            this._PersonArray = new Person[]{TestClasses.createPerson("foo bar", Person.Gender.MALE, 42, new String[0])};
        }

        public int getInt() {
            return this._int;
        }

        public void setInt(int i) {
            this._int = i;
        }

        public long getLong() {
            return this._long;
        }

        public void setLong(long l) {
            this._long = l;
        }

        public String getString() {
            return this._String;
        }

        public void setString(String string) {
            this._String = string;
        }

        public Long getLongWrapper() {
            return this._Long;
        }

        public void setLongWrapper(Long l) {
            this._Long = l;
        }

        public Integer getInteger() {
            return this._Integer;
        }

        public void setInteger(Integer integer) {
            this._Integer = integer;
        }

        public Character getCharacter() {
            return this._Character;
        }

        public void setCharacter(Character character) {
            this._Character = character;
        }

        public Byte getByte() {
            return this._Byte;
        }

        public void setByte(Byte b) {
            this._Byte = b;
        }

        public Double getDouble() {
            return this._Double;
        }

        public void setDouble(Double d) {
            this._Double = d;
        }

        public Float getFloat() {
            return this._Float;
        }

        public void setFloat(Float f) {
            this._Float = f;
        }

        public Short getShort() {
            return this._Short;
        }

        public void setShort(Short s) {
            this._Short = s;
        }

        public BigDecimal getBigDecimal() {
            return this._BigDecimal;
        }

        public void setBigDecimal(BigDecimal bigDecimal) {
            this._BigDecimal = bigDecimal;
        }

        public AtomicInteger getAtomicInteger() {
            return this._AtomicInteger;
        }

        public void setAtomicInteger(AtomicInteger atomicInteger) {
            this._AtomicInteger = atomicInteger;
        }

        public AtomicLong getAtomicLong() {
            return this._AtomicLong;
        }

        public void setAtomicLong(AtomicLong atomicLong) {
            this._AtomicLong = atomicLong;
        }

        public MutableInt getMutableInt() {
            return this._MutableInt;
        }

        public void setMutableInt(MutableInt mutableInt) {
            this._MutableInt = mutableInt;
        }

        public Integer[] getIntegerArray() {
            return this._IntegerArray;
        }

        public void setIntegerArray(Integer[] integerArray) {
            this._IntegerArray = integerArray;
        }

        public Date getDate() {
            return this._Date;
        }

        public void setDate(Date date) {
            this._Date = date;
        }

        public Calendar getCalendar() {
            return this._Calendar;
        }

        public void setCalendar(Calendar calendar) {
            this._Calendar = calendar;
        }

        public List<String> getArrayList() {
            return this._ArrayList;
        }

        public void setArrayList(List<String> arrayList) {
            this._ArrayList = arrayList;
        }

        public int[] getIntArray() {
            return this._intArray;
        }

        public void setIntArray(int[] intArray) {
            this._intArray = intArray;
        }

        public long[] getLongArray() {
            return this._longArray;
        }

        public void setLongArray(long[] longArray) {
            this._longArray = longArray;
        }

        public short[] getShortArray() {
            return this._shortArray;
        }

        public void setShortArray(short[] shortArray) {
            this._shortArray = shortArray;
        }

        public float[] getFloatArray() {
            return this._floatArray;
        }

        public void setFloatArray(float[] floatArray) {
            this._floatArray = floatArray;
        }

        public double[] getDoubleArray() {
            return this._doubleArray;
        }

        public void setDoubleArray(double[] doubleArray) {
            this._doubleArray = doubleArray;
        }

        public byte[] getByteArray() {
            return this._byteArray;
        }

        public void setByteArray(byte[] byteArray) {
            this._byteArray = byteArray;
        }

        public char[] getCharArray() {
            return this._charArray;
        }

        public void setCharArray(char[] charArray) {
            this._charArray = charArray;
        }

        public String[] getStringArray() {
            return this._StringArray;
        }

        public void setStringArray(String[] stringArray) {
            this._StringArray = stringArray;
        }

        public Person[] getPersonArray() {
            return this._PersonArray;
        }

        public void setPersonArray(Person[] personArray) {
            this._PersonArray = personArray;
        }

        public Set<String> getHashSet() {
            return this._HashSet;
        }

        public Map<String, Integer> getHashMap() {
            return this._HashMap;
        }
    }

    public static class ClassWithoutDefaultConstructor {
        final String value;

        public ClassWithoutDefaultConstructor(String value) {
            this.value = value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassWithoutDefaultConstructor other = (ClassWithoutDefaultConstructor)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return "ClassWithoutDefaultConstructor [value=" + this.value + "]";
        }
    }

    private static class PrivateClass {
        String foo;

        private PrivateClass() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.foo == null ? 0 : this.foo.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PrivateClass other = (PrivateClass)obj;
            return !(this.foo == null ? other.foo != null : !this.foo.equals(other.foo));
        }
    }

    public static class PublicClass {
        PrivateClass privateClass;

        public PublicClass() {
        }

        public PublicClass(PrivateClass protectedClass) {
            this.privateClass = protectedClass;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.privateClass == null ? 0 : this.privateClass.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PublicClass other = (PublicClass)obj;
            return !(this.privateClass == null ? other.privateClass != null : !this.privateClass.equals(other.privateClass));
        }
    }

    public static class Email
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String _name;
        private String _email;

        public Email() {
        }

        public Email(String name, String email) {
            this._name = name;
            this._email = email;
        }

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public String getEmail() {
            return this._email;
        }

        public void setEmail(String email) {
            this._email = email;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._email == null ? 0 : this._email.hashCode());
            result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Email other = (Email)obj;
            if (this._email == null ? other._email != null : !this._email.equals(other._email)) {
                return false;
            }
            return !(this._name == null ? other._name != null : !this._name.equals(other._name));
        }

        public String toString() {
            return "Email [_email=" + this._email + ", _name=" + this._name + "]";
        }
    }

    public static class Address
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String _street;
        private final String _zip;
        private final String _city;
        private final String _country;

        public Address(String street, String zip, String city, String country) {
            this._street = street;
            this._zip = zip;
            this._city = city;
            this._country = country;
        }

        public String getStreet() {
            return this._street;
        }

        public String getZip() {
            return this._zip;
        }

        public String getCity() {
            return this._city;
        }

        public String getCountry() {
            return this._country;
        }
    }

    public static class Person
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String _name;
        private Gender _gender;
        private Calendar _dateOfBirth;
        private Integer _age;
        private Map<String, Object> _props;
        private final Collection<Person> _friends = new ArrayList<Person>();
        private final Collection<Address> _addresses = new ArrayList<Address>();

        public String getName() {
            return this._name;
        }

        public void addFriend(Person p) {
            this._friends.add(p);
        }

        public void addAddress(Address a) {
            this._addresses.add(a);
        }

        public void setName(String name) {
            this._name = name;
        }

        public Map<String, Object> getProps() {
            return this._props;
        }

        public void setProps(Map<String, Object> props) {
            this._props = props;
        }

        public Gender getGender() {
            return this._gender;
        }

        public void setGender(Gender gender) {
            this._gender = gender;
        }

        public Integer getAge() {
            return this._age;
        }

        public void setAge(Integer age) {
            this._age = age;
        }

        public Calendar getDateOfBirth() {
            return this._dateOfBirth;
        }

        public void setDateOfBirth(Calendar dataOfBirth) {
            this._dateOfBirth = dataOfBirth;
        }

        public Collection<Person> getFriends() {
            return this._friends;
        }

        public Collection<Address> getAddresses() {
            return this._addresses;
        }

        private boolean flatEquals(Collection<?> c1, Collection<?> c2) {
            return c1 == c2 || c1 != null && c2 != null && c1.size() == c2.size();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._age == null ? 0 : this._age.hashCode());
            result = 31 * result + (this._friends == null ? 0 : this._friends.size());
            result = 31 * result + (this._gender == null ? 0 : this._gender.hashCode());
            result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
            result = 31 * result + (this._props == null ? 0 : ((Object)this._props).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Person other = (Person)obj;
            if (this._age == null ? other._age != null : !this._age.equals(other._age)) {
                return false;
            }
            if (this._friends == null ? other._friends != null : !this.flatEquals(this._friends, other._friends)) {
                return false;
            }
            if (this._gender == null ? other._gender != null : !this._gender.equals((Object)other._gender)) {
                return false;
            }
            if (this._name == null ? other._name != null : !this._name.equals(other._name)) {
                return false;
            }
            return !(this._props == null ? other._props != null : !((Object)this._props).equals(other._props));
        }

        public String toString() {
            return "Person [_age=" + this._age + ", _friends.size=" + this._friends.size() + ", _gender=" + (Object)((Object)this._gender) + ", _name=" + this._name + ", _props=" + this._props + "]";
        }

        static enum Gender {
            MALE,
            FEMALE;

        }
    }

    public static class MyXMLSerializable
    implements XMLSerializable {
        private static final long serialVersionUID = -3392119483974151376L;
        protected static final XMLFormat<MyXMLSerializable> XML = new XMLFormat<MyXMLSerializable>(MyXMLSerializable.class){

            public MyXMLSerializable newInstance(Class<MyXMLSerializable> cls, XMLFormat.InputElement xml) throws XMLStreamException {
                return new MyXMLSerializable(Runtime.getRuntime());
            }

            public void write(MyXMLSerializable obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            }

            public void read(XMLFormat.InputElement xml, MyXMLSerializable obj) {
            }
        };
        private final transient Runtime _runtime;

        public MyXMLSerializable(Runtime runtime) {
            this._runtime = runtime;
        }

        public Runtime getRuntime() {
            return this._runtime;
        }
    }

    static class SomeInterfaceImpl
    implements SomeInterface {
        SomeInterfaceImpl() {
        }

        @Override
        public String hello() {
            return "hi";
        }
    }

    static interface SomeInterface {
        public String hello();
    }

    static class MyInvocationHandler
    implements InvocationHandler {
        private final Class<?> _targetClazz;
        private transient Object _target;

        public MyInvocationHandler(Class<?> targetClazz) {
            this._targetClazz = targetClazz;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this._target == null) {
                this._target = this._targetClazz.newInstance();
            }
            return method.invoke(this._target, args);
        }
    }
}

