/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.TranscoderService;
import javax.annotation.Nonnull;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class SessionValidityInfo {
    private static final Log LOG = LogFactory.getLog(SessionValidityInfo.class);
    private final int _maxInactiveInterval;
    private final long _lastAccessedTime;
    private final long _thisAccessedTime;

    public SessionValidityInfo(int maxInactiveInterval, long lastAccessedTime, long thisAccessedTime) {
        this._maxInactiveInterval = maxInactiveInterval;
        this._lastAccessedTime = lastAccessedTime;
        this._thisAccessedTime = thisAccessedTime;
    }

    @Nonnull
    public static byte[] encode(long maxInactiveInterval, long lastAccessedTime, long thisAccessedTime) {
        int idx = 0;
        byte[] data = new byte[20];
        TranscoderService.encodeNum(maxInactiveInterval, data, idx, 4);
        TranscoderService.encodeNum(lastAccessedTime, data, idx += 4, 8);
        TranscoderService.encodeNum(thisAccessedTime, data, idx += 8, 8);
        return data;
    }

    @Nonnull
    public static SessionValidityInfo decode(@Nonnull byte[] data) {
        int idx = 0;
        int maxInactiveInterval = (int)TranscoderService.decodeNum(data, idx, 4);
        long lastAccessedTime = TranscoderService.decodeNum(data, idx += 4, 8);
        long thisAccessedTime = TranscoderService.decodeNum(data, idx += 8, 8);
        return new SessionValidityInfo(maxInactiveInterval, lastAccessedTime, thisAccessedTime);
    }

    public int getMaxInactiveInterval() {
        return this._maxInactiveInterval;
    }

    public long getLastAccessedTime() {
        return this._lastAccessedTime;
    }

    public long getThisAccessedTime() {
        return this._thisAccessedTime;
    }

    public boolean isValid() {
        long timeNow = System.currentTimeMillis();
        int timeIdle = (int)((timeNow - this._thisAccessedTime) / 1000L);
        return this._maxInactiveInterval <= 0 || timeIdle < this._maxInactiveInterval;
    }
}

