/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;

public class LRUCache<K, V> {
    private final int _size;
    private final long _ttl;
    private final LinkedHashMap<K, ManagedItem<V>> _map;

    public LRUCache(int size) {
        this(size, -1L);
    }

    public LRUCache(int size, long ttlInMillis) {
        this._size = size;
        this._ttl = ttlInMillis;
        this._map = new LinkedHashMap(size / 2, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedHashMap<K, ManagedItem<V>> linkedHashMap = this._map;
        synchronized (linkedHashMap) {
            this._map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        LinkedHashMap<K, ManagedItem<V>> linkedHashMap = this._map;
        synchronized (linkedHashMap) {
            ManagedItem previous = this._map.put(key, new ManagedItem(value, System.currentTimeMillis()));
            while (this._map.size() > this._size) {
                this._map.remove(this._map.keySet().iterator().next());
            }
            return (V)(previous != null ? previous._value : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putIfDifferent(K key, V value) {
        LinkedHashMap<K, ManagedItem<V>> linkedHashMap = this._map;
        synchronized (linkedHashMap) {
            ManagedItem<V> item = this._map.get(key);
            if (item == null || ((ManagedItem)item)._value == null || !((ManagedItem)item)._value.equals(value)) {
                return this.put(key, value);
            }
            return (V)((ManagedItem)item)._value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        LinkedHashMap<K, ManagedItem<V>> linkedHashMap = this._map;
        synchronized (linkedHashMap) {
            ManagedItem removed = (ManagedItem)this._map.remove(key);
            return (V)(removed != null ? removed._value : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        LinkedHashMap<K, ManagedItem<V>> linkedHashMap = this._map;
        synchronized (linkedHashMap) {
            ManagedItem<V> item = this._map.get(key);
            if (item == null) {
                return null;
            }
            if (this._ttl > -1L && System.currentTimeMillis() - ((ManagedItem)item)._insertionTime > this._ttl) {
                this._map.remove(key);
                return null;
            }
            return (V)((ManagedItem)item)._value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(K key) {
        LinkedHashMap<K, ManagedItem<V>> linkedHashMap = this._map;
        synchronized (linkedHashMap) {
            return this._map.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<K> getKeys() {
        LinkedHashMap<K, ManagedItem<V>> linkedHashMap = this._map;
        synchronized (linkedHashMap) {
            return new java.util.ArrayList<K>(this._map.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<K> getKeysSortedByValue(final Comparator<V> comparator) {
        LinkedHashMap<K, ManagedItem<V>> linkedHashMap = this._map;
        synchronized (linkedHashMap) {
            Map.Entry[] a = this._map.entrySet().toArray(new Map.Entry[this._map.size()]);
            Comparator c = new Comparator<Map.Entry<K, ManagedItem<V>>>(){

                @Override
                public int compare(Map.Entry<K, ManagedItem<V>> o1, Map.Entry<K, ManagedItem<V>> o2) {
                    return comparator.compare(o1.getValue()._value, o2.getValue()._value);
                }
            };
            Arrays.sort(a, c);
            return new ArrayList(a);
        }
    }

    private static class ArrayList<E, V>
    extends AbstractList<E>
    implements RandomAccess {
        private final Map.Entry<E, ManagedItem<V>>[] a;

        ArrayList(Map.Entry<E, ManagedItem<V>>[] array) {
            if (array == null) {
                throw new NullPointerException();
            }
            this.a = array;
        }

        @Override
        public int size() {
            return this.a.length;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public E get(int index) {
            return this.a[index].getKey();
        }

        @Override
        public E set(int index, E element) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public int indexOf(Object o) {
            if (o == null) {
                for (int i = 0; i < this.a.length; ++i) {
                    if (this.a[i] != null && this.a[i].getKey() != null) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < this.a.length; ++i) {
                    if (!o.equals(this.a[i].getKey())) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) != -1;
        }
    }

    private static final class ManagedItem<T> {
        private final T _value;
        private final long _insertionTime;

        private ManagedItem(T value, long accessTime) {
            this._value = value;
            this._insertionTime = accessTime;
        }
    }
}

