/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.NodeAvailabilityCache;
import de.javakaffee.web.msm.NodeIdList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class NodeIdService {
    private static final Log LOG = LogFactory.getLog(NodeIdService.class);
    private final Random _random = new Random();
    private final NodeAvailabilityCache<String> _nodeAvailabilityCache;
    private final NodeIdList _nodeIds;
    private final List<String> _failoverNodeIds;

    public NodeIdService(NodeAvailabilityCache<String> nodeAvailabilityCache, NodeIdList nodeIds, List<String> failoverNodeIds) {
        this._nodeAvailabilityCache = nodeAvailabilityCache;
        this._nodeIds = nodeIds;
        this._failoverNodeIds = failoverNodeIds;
    }

    NodeIdService(List<String> nodeIds, List<String> failoverNodeIds) {
        this(null, new NodeIdList(nodeIds), failoverNodeIds);
    }

    public boolean isNodeAvailable(@Nonnull String nodeId) {
        return this._nodeAvailabilityCache.isNodeAvailable(nodeId);
    }

    public void setNodeAvailable(String nodeId, boolean available) {
        this._nodeAvailabilityCache.setNodeAvailable(nodeId, available);
    }

    public String getAvailableNodeId(String nodeId) {
        String result = null;
        result = this.getRandomNextNodeId(nodeId, this._nodeIds);
        if (result == null && this._failoverNodeIds != null && !this._failoverNodeIds.isEmpty()) {
            result = this.getRandomNextNodeId(nodeId, this._failoverNodeIds);
        }
        return result;
    }

    @CheckForNull
    public String getNextNodeId(@Nonnull String nodeId) throws IllegalArgumentException {
        return this._nodeIds.getNextNodeId(nodeId);
    }

    protected String getRandomNextNodeId(String nodeId, Collection<String> nodeIds) {
        ArrayList<String> otherNodeIds = new ArrayList<String>(nodeIds);
        otherNodeIds.remove(nodeId);
        while (!otherNodeIds.isEmpty()) {
            String nodeIdToCheck = (String)otherNodeIds.get(this._random.nextInt(otherNodeIds.size()));
            if (this.isNodeAvailable(nodeIdToCheck)) {
                return nodeIdToCheck;
            }
            otherNodeIds.remove(nodeIdToCheck);
        }
        return null;
    }

    public String getMemcachedNodeId() {
        String nodeId = (String)this._nodeIds.get(this._random.nextInt(this._nodeIds.size()));
        return this.isNodeAvailable(nodeId) ? nodeId : this.getAvailableNodeId(nodeId);
    }

    List<String> getNodeIds() {
        return new ArrayList<String>(this._nodeIds);
    }

    List<String> getFailoverNodeIds() {
        return new ArrayList<String>(this._failoverNodeIds);
    }

    public String getNewNodeIdIfUnavailable(String nodeId) {
        String newNodeId;
        if (nodeId == null) {
            newNodeId = this.getMemcachedNodeId();
        } else if (!this.isNodeAvailable(nodeId)) {
            newNodeId = this.getAvailableNodeId(nodeId);
            if (newNodeId == null) {
                LOG.warn((Object)("The node " + nodeId + " is not available and there's no node for relocation left."));
            }
        } else {
            newNodeId = null;
        }
        return newNodeId;
    }
}

