/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class SessionIdFormat {
    private static final String BACKUP_PREFIX = "bak:";
    private static final Log LOG = LogFactory.getLog(SessionIdFormat.class);
    private final Pattern _pattern = Pattern.compile("[^-.]+-[^.]+(\\.[^.]+)?");

    @Nonnull
    public String createSessionId(@Nonnull String sessionId, @Nullable String memcachedId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating new session id with orig id '" + sessionId + "' and memcached id '" + memcachedId + "'."));
        }
        if (memcachedId == null) {
            return sessionId;
        }
        int idx = sessionId.indexOf(46);
        if (idx < 0) {
            return sessionId + "-" + memcachedId;
        }
        return sessionId.substring(0, idx) + "-" + memcachedId + sessionId.substring(idx);
    }

    @Nonnull
    public String createNewSessionId(@Nonnull String sessionId, @Nonnull String newMemcachedId) {
        int idxDot = sessionId.indexOf(46);
        if (idxDot != -1) {
            String plainSessionId = sessionId.substring(0, idxDot);
            String jvmRouteWithDot = sessionId.substring(idxDot);
            return this.appendOrReplaceMemcachedId(plainSessionId, newMemcachedId) + jvmRouteWithDot;
        }
        return this.appendOrReplaceMemcachedId(sessionId, newMemcachedId);
    }

    @Nonnull
    private String appendOrReplaceMemcachedId(@Nonnull String sessionId, @Nonnull String newMemcachedId) {
        int idxDash = sessionId.indexOf(45);
        if (idxDash < 0) {
            return sessionId + "-" + newMemcachedId;
        }
        return sessionId.substring(0, idxDash + 1) + newMemcachedId;
    }

    @Nonnull
    public String changeJvmRoute(@Nonnull String sessionId, @Nonnull String newJvmRoute) {
        return this.stripJvmRoute(sessionId) + "." + newJvmRoute;
    }

    public boolean isValid(@Nullable String sessionId) {
        return sessionId != null && this._pattern.matcher(sessionId).matches();
    }

    @CheckForNull
    public String extractMemcachedId(@Nonnull String sessionId) {
        int idxDash = sessionId.indexOf(45);
        if (idxDash < 0) {
            return null;
        }
        int idxDot = sessionId.indexOf(46);
        if (idxDot < 0) {
            return sessionId.substring(idxDash + 1);
        }
        if (idxDot < idxDash) {
            return null;
        }
        return sessionId.substring(idxDash + 1, idxDot);
    }

    @CheckForNull
    public String extractJvmRoute(@Nonnull String sessionId) {
        int idxDot = sessionId.indexOf(46);
        return idxDot < 0 ? null : sessionId.substring(idxDot + 1);
    }

    @Nonnull
    public String stripJvmRoute(@Nonnull String sessionId) {
        int idxDot = sessionId.indexOf(46);
        return idxDot < 0 ? sessionId : sessionId.substring(0, idxDot);
    }

    @Nonnull
    public String createLockName(@Nonnull String sessionId) {
        if (sessionId == null) {
            throw new IllegalArgumentException("The sessionId must not be null.");
        }
        return "lock:" + sessionId;
    }

    @Nonnull
    public String createBackupKey(@Nonnull String origKey) {
        if (origKey == null) {
            throw new IllegalArgumentException("The origKey must not be null.");
        }
        return BACKUP_PREFIX + origKey;
    }

    public boolean isBackupKey(@Nonnull String key) {
        return key.startsWith(BACKUP_PREFIX);
    }
}

