/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.LockingStrategy;
import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.Statistics;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class RequestTrackingHostValve
extends ValveBase {
    private static final String REQUEST_IGNORED = "de.javakaffee.msm.request.ignored";
    public static final String REQUEST_PROCESS = "de.javakaffee.msm.request.process";
    public static final String SESSION_ID_CHANGED = "de.javakaffee.msm.sessionIdChanged";
    public static final String REQUEST_PROCESSED = "de.javakaffee.msm.request.processed";
    static final String RELOCATE = "session.relocate";
    protected static final Log _log = LogFactory.getLog(RequestTrackingHostValve.class);
    private final Pattern _ignorePattern;
    private final MemcachedSessionService _sessionBackupService;
    private final Statistics _statistics;
    private final AtomicBoolean _enabled;
    protected final String _sessionCookieName;
    @CheckForNull
    private LockingStrategy _lockingStrategy;
    private static final String MSM_REQUEST_ID = "msm.requestId";
    private static final boolean IS_TOMCAT_6;

    public RequestTrackingHostValve(@Nullable String ignorePattern, @Nonnull String sessionCookieName, @Nonnull MemcachedSessionService sessionBackupService, @Nonnull Statistics statistics, @Nonnull AtomicBoolean enabled) {
        if (ignorePattern != null) {
            _log.info((Object)("Setting ignorePattern to " + ignorePattern));
            this._ignorePattern = Pattern.compile(ignorePattern);
        } else {
            this._ignorePattern = null;
        }
        this._sessionCookieName = sessionCookieName;
        this._sessionBackupService = sessionBackupService;
        this._statistics = statistics;
        this._enabled = enabled;
    }

    protected String getSessionCookieName() {
        return this._sessionCookieName;
    }

    public boolean isIgnoredRequest() {
        Request request = this._lockingStrategy == null ? null : this._lockingStrategy.getCurrentRequest();
        return request != null && request.getNote(REQUEST_IGNORED) == Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        block12: {
            String requestId;
            block13: {
                block11: {
                    requestId = RequestTrackingHostValve.getURIWithQueryString(request);
                    if (this._enabled.get()) break block11;
                    this.getNext().invoke(request, response);
                    break block12;
                }
                if (this._ignorePattern == null || !this._ignorePattern.matcher(requestId).matches()) break block13;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(">>>>>> Ignoring: " + requestId + " (requestedSessionId " + request.getRequestedSessionId() + ") =================="));
                }
                try {
                    this.storeRequestThreadLocal(request);
                    request.setNote(REQUEST_IGNORED, (Object)Boolean.TRUE);
                    this.getNext().invoke(request, response);
                }
                finally {
                    String sessionId;
                    if (request.getNote(REQUEST_PROCESSED) == Boolean.TRUE && (sessionId = this.getSessionId(request, response)) != null) {
                        this._sessionBackupService.requestFinished(sessionId, requestId);
                    }
                    this.resetRequestThreadLocal();
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("<<<<<< Ignored: " + requestId + " =================="));
                }
                break block12;
            }
            request.setNote(REQUEST_PROCESS, (Object)Boolean.TRUE);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(">>>>>> Request starting: " + requestId + " (requestedSessionId " + request.getRequestedSessionId() + ") =================="));
            }
            try {
                this.storeRequestThreadLocal(request);
                this.getNext().invoke(request, response);
            }
            catch (Throwable throwable) {
                Boolean sessionIdChanged = (Boolean)request.getNote(SESSION_ID_CHANGED);
                this.backupSession(request, response, sessionIdChanged == null ? false : sessionIdChanged);
                this.resetRequestThreadLocal();
                throw throwable;
            }
            Boolean sessionIdChanged = (Boolean)request.getNote(SESSION_ID_CHANGED);
            this.backupSession(request, response, sessionIdChanged == null ? false : sessionIdChanged);
            this.resetRequestThreadLocal();
            if (_log.isDebugEnabled()) {
                this.logDebugRequestSessionCookie(request);
                this.logDebugResponseCookie(response);
                _log.debug((Object)("<<<<<< Request finished: " + requestId + " =================="));
            }
        }
    }

    protected void logDebugRequestSessionCookie(Request request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(this._sessionCookieName)) continue;
            _log.debug((Object)("Have request session cookie: domain=" + cookie.getDomain() + ", maxAge=" + cookie.getMaxAge() + ", path=" + cookie.getPath() + ", value=" + cookie.getValue() + ", version=" + cookie.getVersion() + ", secure=" + cookie.getSecure()));
        }
    }

    @Nonnull
    protected static String getURIWithQueryString(@Nonnull Request request) {
        Object note = request.getNote(MSM_REQUEST_ID);
        if (note != null) {
            return note.toString();
        }
        StringBuilder sb = new StringBuilder(30);
        sb.append(request.getMethod()).append(' ').append(request.getRequestURI());
        if (!RequestTrackingHostValve.isPostMethod(request) && request.getQueryString() != null) {
            sb.append('?').append(request.getQueryString());
        }
        String result = sb.toString();
        request.setNote(MSM_REQUEST_ID, (Object)result);
        return result;
    }

    protected static boolean isPostMethod(Request request) {
        String method = request.getMethod();
        if (method == null && _log.isDebugEnabled()) {
            _log.debug((Object)("No method set for request " + request.getRequestURI() + (request.getQueryString() != null ? "?" + request.getQueryString() : "")));
        }
        return method != null ? method.toLowerCase().equals("post") : false;
    }

    private void resetRequestThreadLocal() {
        if (this._lockingStrategy != null) {
            this._lockingStrategy.onRequestFinished();
        }
    }

    private void storeRequestThreadLocal(@Nonnull Request request) {
        if (this._lockingStrategy != null) {
            this._lockingStrategy.onRequestStart(request);
        }
    }

    private void backupSession(Request request, Response response, boolean sessionIdChanged) {
        String sessionId = this.getSessionId(request, response);
        if (sessionId != null) {
            this._statistics.requestWithSession();
            this._sessionBackupService.backupSession(sessionId, sessionIdChanged, RequestTrackingHostValve.getURIWithQueryString(request));
        } else {
            this._statistics.requestWithoutSession();
        }
    }

    private String getSessionId(Request request, Response response) {
        String sessionId = this.getSessionIdFromResponseSessionCookie(response);
        return sessionId != null ? sessionId : request.getRequestedSessionId();
    }

    private String getSessionIdFromResponseSessionCookie(Response response) {
        String[] headers = this.getResponseSetCookieHeaders(response);
        if (headers == null) {
            return null;
        }
        for (String header : headers) {
            if (header == null || !header.contains(this._sessionCookieName)) continue;
            String sessionIdPrefix = this._sessionCookieName + "=";
            int idxNameStart = header.indexOf(sessionIdPrefix);
            int idxValueStart = idxNameStart + sessionIdPrefix.length();
            int idxValueEnd = header.indexOf(59, idxNameStart);
            if (idxValueEnd == -1) {
                idxValueEnd = header.indexOf(32, idxValueStart);
            }
            if (idxValueEnd == -1) {
                idxValueEnd = header.length();
            }
            return header.substring(idxValueStart, idxValueEnd);
        }
        return null;
    }

    private String[] getResponseSetCookieHeaders(Response response) {
        try {
            if (IS_TOMCAT_6) {
                Method getHeaderValues = response.getClass().getMethod("getHeaderValues", String.class);
                String[] result = (String[])getHeaderValues.invoke((Object)response, "Set-Cookie");
                return result;
            }
            Method getHeaders = response.getClass().getMethod("getHeaders", String.class);
            Collection result = (Collection)getHeaders.invoke((Object)response, "Set-Cookie");
            return result.toArray(new String[result.size()]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void logDebugResponseCookie(Response response) {
        String header = response.getHeader("Set-Cookie");
        if (header != null && header.contains(this._sessionCookieName)) {
            _log.debug((Object)("Request finished, with Set-Cookie header: " + header));
        }
    }

    public void setLockingStrategy(@Nullable LockingStrategy lockingStrategy) {
        this._lockingStrategy = lockingStrategy;
    }

    static {
        Method getHeaderValues = null;
        try {
            getHeaderValues = Response.class.getMethod("getHeaderValues", String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        IS_TOMCAT_6 = getHeaderValues != null;
    }
}

