/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.MemcachedBackupSession;
import de.javakaffee.web.msm.SessionTranscoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.CustomObjectInputStream;

public class JavaSessionSerializationTranscoder
extends SessionTranscoder {
    private final Manager _manager;

    public JavaSessionSerializationTranscoder(Manager manager) {
        this._manager = manager;
    }

    protected byte[] serialize(Object o) {
        if (o == null) {
            throw new NullPointerException("Can't serialize null");
        }
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            ((StandardSession)o).writeObjectData(oos);
            byte[] byArray = bos.toByteArray();
            this.closeSilently(bos);
            this.closeSilently(oos);
            return byArray;
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Non-serializable object", e);
            }
            catch (Throwable throwable) {
                this.closeSilently(bos);
                this.closeSilently(oos);
                throw throwable;
            }
        }
    }

    private void closeSilently(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void closeSilently(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected MemcachedBackupSession deserialize(byte[] in) {
        ByteArrayInputStream bis = null;
        ObjectInputStream ois = null;
        try {
            bis = new ByteArrayInputStream(in);
            ois = this.createObjectInputStream(bis);
            MemcachedBackupSession session = (MemcachedBackupSession)this._manager.createEmptySession();
            session.readObjectData(ois);
            session.setManager(this._manager);
            MemcachedBackupSession memcachedBackupSession = session;
            this.closeSilently(bis);
            this.closeSilently(ois);
            return memcachedBackupSession;
        }
        catch (ClassNotFoundException e) {
            try {
                this.getLogger().warn("Caught CNFE decoding %d bytes of data", new Object[]{in.length, e});
                throw new RuntimeException("Caught CNFE decoding data", e);
                catch (IOException e2) {
                    this.getLogger().warn("Caught IOException decoding %d bytes of data", new Object[]{in.length, e2});
                    throw new RuntimeException("Caught IOException decoding data", e2);
                }
            }
            catch (Throwable throwable) {
                this.closeSilently(bis);
                this.closeSilently(ois);
                throw throwable;
            }
        }
    }

    private ObjectInputStream createObjectInputStream(ByteArrayInputStream bis) throws IOException {
        Loader loader = null;
        ClassLoader classLoader = null;
        if (this._manager.getContainer() != null) {
            loader = this._manager.getContainer().getLoader();
        }
        if (loader != null) {
            classLoader = loader.getClassLoader();
        }
        ObjectInputStream ois = classLoader != null ? new CustomObjectInputStream((InputStream)bis, classLoader) : new ObjectInputStream(bis);
        return ois;
    }
}

