/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.CurrentRequest;
import de.javakaffee.web.msm.LockingStrategy;
import de.javakaffee.web.msm.MemcachedBackupSession;
import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.RequestTrackingContextValve;
import de.javakaffee.web.msm.RequestTrackingHostValve;
import de.javakaffee.web.msm.Statistics;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.security.Principal;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Response;
import org.apache.catalina.ha.session.SerializablePrincipal;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.SessionConfig;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class MemcachedBackupSessionManager
extends ManagerBase
implements Lifecycle,
PropertyChangeListener,
MemcachedSessionService.SessionManager {
    protected static final String NAME = MemcachedBackupSessionManager.class.getSimpleName();
    private static final String INFO = NAME + "/1.0";
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected MemcachedSessionService _msm = new MemcachedSessionService(this){

        protected RequestTrackingContextValve createRequestTrackingContextValve(String sessionCookieName) {
            RequestTrackingContextValve result = super.createRequestTrackingContextValve(sessionCookieName);
            result.setAsyncSupported(true);
            return result;
        }

        protected RequestTrackingHostValve createRequestTrackingHostValve(String sessionCookieName, CurrentRequest currentRequest) {
            RequestTrackingHostValve result = super.createRequestTrackingHostValve(sessionCookieName, currentRequest);
            result.setAsyncSupported(true);
            return result;
        }
    };

    public String getInfo() {
        return INFO;
    }

    public String getName() {
        return NAME;
    }

    public void load() throws ClassNotFoundException, IOException {
    }

    public void unload() throws IOException {
    }

    public MemcachedBackupSession createSession(String sessionId) {
        return this._msm.createSession(sessionId);
    }

    public MemcachedBackupSession createEmptySession() {
        return this._msm.createEmptySession();
    }

    public MemcachedBackupSession newMemcachedBackupSession() {
        return new MemcachedBackupSession((MemcachedSessionService.SessionManager)this);
    }

    public synchronized String generateSessionId() {
        return this._msm.newSessionId(super.generateSessionId());
    }

    public void expireSession(String sessionId) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("expireSession invoked: " + sessionId));
        }
        super.expireSession(sessionId);
        this._msm.deleteFromMemcached(sessionId);
    }

    public void remove(Session session, boolean update) {
        this.removeInternal(session, update, session.getNote("node.failure") != Boolean.TRUE);
    }

    public void removeInternal(Session session, boolean update) {
        super.remove(session, update);
    }

    private void removeInternal(Session session, boolean update, boolean removeFromMemcached) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("remove invoked, removeFromMemcached: " + removeFromMemcached + ", id: " + session.getId()));
        }
        if (removeFromMemcached) {
            this._msm.deleteFromMemcached(session.getId());
        }
        super.remove(session, update);
        this._msm.sessionRemoved((MemcachedBackupSession)session);
    }

    public Session findSession(String id) throws IOException {
        return this._msm.findSession(id);
    }

    public void changeSessionId(Session session) {
        super.changeSessionId(session);
        ((MemcachedBackupSession)session).setSessionIdChanged(true);
    }

    public void setMemcachedNodes(String memcachedNodes) {
        this._msm.setMemcachedNodes(memcachedNodes);
    }

    public String getMemcachedNodes() {
        return this._msm.getMemcachedNodes();
    }

    public void setFailoverNodes(String failoverNodes) {
        this._msm.setFailoverNodes(failoverNodes);
    }

    public String getFailoverNodes() {
        return this._msm.getFailoverNodes();
    }

    public void setRequestUriIgnorePattern(String requestUriIgnorePattern) {
        this._msm.setRequestUriIgnorePattern(requestUriIgnorePattern);
    }

    @CheckForNull
    Pattern getSessionAttributePattern() {
        return this._msm.getSessionAttributePattern();
    }

    @CheckForNull
    public String getSessionAttributeFilter() {
        return this._msm.getSessionAttributeFilter();
    }

    public void setSessionAttributeFilter(@Nullable String sessionAttributeFilter) {
        this._msm.setSessionAttributeFilter(sessionAttributeFilter);
    }

    public void setTranscoderFactoryClass(String transcoderFactoryClassName) {
        this._msm.setTranscoderFactoryClass(transcoderFactoryClassName);
    }

    public void setCopyCollectionsForSerialization(boolean copyCollectionsForSerialization) {
        this._msm.setCopyCollectionsForSerialization(copyCollectionsForSerialization);
    }

    public void setCustomConverter(String customConverterClassNames) {
        this._msm.setCustomConverter(customConverterClassNames);
    }

    public void setEnableStatistics(boolean enableStatistics) {
        this._msm.setEnableStatistics(enableStatistics);
    }

    public void setBackupThreadCount(int backupThreadCount) {
        this._msm.setBackupThreadCount(backupThreadCount);
    }

    public int getBackupThreadCount() {
        return this._msm.getBackupThreadCount();
    }

    public void setMemcachedProtocol(String memcachedProtocol) {
        this._msm.setMemcachedProtocol(memcachedProtocol);
    }

    public void setEnabled(boolean enabled) throws IllegalStateException {
        this._msm.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this._msm.isEnabled();
    }

    public void setSticky(boolean sticky) {
        this._msm.setSticky(sticky);
    }

    public boolean isSticky() {
        return this._msm.isSticky();
    }

    public void setOperationTimeout(long operationTimeout) {
        this._msm.setOperationTimeout(operationTimeout);
    }

    public long getOperationTimeout() {
        return this._msm.getOperationTimeout();
    }

    public void setLockingMode(@Nullable String lockingMode) {
        this._msm.setLockingMode(lockingMode);
    }

    public void setLockingMode(@Nullable LockingStrategy.LockingMode lockingMode, @Nullable Pattern uriPattern, boolean storeSecondaryBackup) {
        this._msm.setLockingMode(lockingMode, uriPattern, storeSecondaryBackup);
    }

    public void setUsername(String username) {
        this._msm.setUsername(username);
    }

    public void setPassword(String password) {
        this._msm.setPassword(password);
    }

    public void startInternal() throws LifecycleException {
        super.startInternal();
        this._msm.startInternal();
        this.setState(LifecycleState.STARTING);
    }

    public void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        if (this._msm.isSticky()) {
            this._log.info((Object)"Removing sessions from local session map.");
            for (Session session : this.sessions.values()) {
                this.swapOut((StandardSession)session);
            }
        }
        this._msm.shutdown();
        super.stopInternal();
    }

    private void swapOut(@Nonnull StandardSession session) {
        if (!session.isValid()) {
            return;
        }
        session.passivate();
        this.removeInternal((Session)session, true);
        session.recycle();
    }

    public void backgroundProcess() {
        this._msm.updateExpirationInMemcached();
        super.backgroundProcess();
    }

    public void setSessionBackupAsync(boolean sessionBackupAsync) {
        this._msm.setSessionBackupAsync(sessionBackupAsync);
    }

    public boolean isSessionBackupAsync() {
        return this._msm.isSessionBackupAsync();
    }

    public void setSessionBackupTimeout(int sessionBackupTimeout) {
        this._msm.setSessionBackupTimeout(sessionBackupTimeout);
    }

    public long getSessionBackupTimeout() {
        return this._msm.getSessionBackupTimeout();
    }

    public long getMsmStatNumBackupFailures() {
        return this._msm.getStatistics().getRequestsWithBackupFailure();
    }

    public long getMsmStatNumTomcatFailover() {
        return this._msm.getStatistics().getRequestsWithTomcatFailover();
    }

    public long getMsmStatNumMemcachedFailover() {
        return this._msm.getStatistics().getRequestsWithMemcachedFailover();
    }

    public long getMsmStatNumRequestsWithoutSession() {
        return this._msm.getStatistics().getRequestsWithoutSession();
    }

    public long getMsmStatNumNoSessionAccess() {
        return this._msm.getStatistics().getRequestsWithoutSessionAccess();
    }

    public long getMsmStatNumNoAttributesAccess() {
        return this._msm.getStatistics().getRequestsWithoutAttributesAccess();
    }

    public long getMsmStatNumNoSessionModification() {
        return this._msm.getStatistics().getRequestsWithoutSessionModification();
    }

    public long getMsmStatNumRequestsWithSession() {
        return this._msm.getStatistics().getRequestsWithSession();
    }

    public long getMsmStatNumNonStickySessionsPingFailed() {
        return this._msm.getStatistics().getNonStickySessionsPingFailed();
    }

    public long getMsmStatNumNonStickySessionsReadOnlyRequest() {
        return this._msm.getStatistics().getNonStickySessionsReadOnlyRequest();
    }

    public String[] getMsmStatAttributesSerializationInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.ATTRIBUTES_SERIALIZATION).getInfo();
    }

    public String[] getMsmStatEffectiveBackupInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.EFFECTIVE_BACKUP).getInfo();
    }

    public String[] getMsmStatBackupInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.BACKUP).getInfo();
    }

    public String[] getMsmStatSessionsLoadedFromMemcachedInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.LOAD_FROM_MEMCACHED).getInfo();
    }

    public String[] getMsmStatSessionsDeletedFromMemcachedInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.DELETE_FROM_MEMCACHED).getInfo();
    }

    public String[] getMsmStatSessionDeserializationInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.SESSION_DESERIALIZATION).getInfo();
    }

    public String[] getMsmStatCachedDataSizeInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.CACHED_DATA_SIZE).getInfo();
    }

    public String[] getMsmStatMemcachedUpdateInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.MEMCACHED_UPDATE).getInfo();
    }

    public String[] getMsmStatNonStickyAcquireLockInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.ACQUIRE_LOCK).getInfo();
    }

    public String[] getMsmStatNonStickyAcquireLockFailureInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.ACQUIRE_LOCK_FAILURE).getInfo();
    }

    public String[] getMsmStatNonStickyReleaseLockInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.RELEASE_LOCK).getInfo();
    }

    public String[] getMsmStatNonStickyOnBackupWithoutLoadedSessionInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.NON_STICKY_ON_BACKUP_WITHOUT_LOADED_SESSION).getInfo();
    }

    public String[] getMsmStatNonStickyAfterBackupInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.NON_STICKY_AFTER_BACKUP).getInfo();
    }

    public String[] getMsmStatNonStickyAfterLoadFromMemcachedInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.NON_STICKY_AFTER_LOAD_FROM_MEMCACHED).getInfo();
    }

    public String[] getMsmStatNonStickyAfterDeleteFromMemcachedInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.NON_STICKY_AFTER_DELETE_FROM_MEMCACHED).getInfo();
    }

    public String getSessionCookieName() {
        return SessionConfig.getSessionCookieName((Context)((Context)this.getContainer()));
    }

    public MemcachedBackupSession getSessionInternal(String sessionId) {
        return (MemcachedBackupSession)this.sessions.get(sessionId);
    }

    public Map<String, Session> getSessionsInternal() {
        return this.sessions;
    }

    public String getString(String key) {
        return sm.getString(key);
    }

    public void incrementSessionCounter() {
        ++this.sessionCounter;
    }

    public void incrementRejectedSessions() {
        ++this.rejectedSessions;
    }

    public boolean isInitialized() {
        return this.getState() == LifecycleState.INITIALIZED || this.getState() == LifecycleState.STARTED;
    }

    public String getString(String key, Object ... args) {
        return sm.getString(key, args);
    }

    public Principal readPrincipal(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        return SerializablePrincipal.readPrincipal((ObjectInput)ois);
    }

    public MemcachedSessionService getMemcachedSessionService() {
        return this._msm;
    }

    public String[] getSetCookieHeaders(Response response) {
        Collection result = response.getHeaders("Set-Cookie");
        return result.toArray(new String[result.size()]);
    }
}

