/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.guava;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.MapSerializer;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class ImmutableMapSerializer
extends Serializer<ImmutableMap<Object, ? extends Object>> {
    private static final boolean DOES_NOT_ACCEPT_NULL = true;
    private static final boolean IMMUTABLE = true;
    private MapSerializer mapSerializer;

    private ImmutableMapSerializer() {
        super(true, true);
    }

    private ImmutableMapSerializer(MapSerializer mapSerializer) {
        this();
        this.mapSerializer = mapSerializer;
    }

    public void write(Kryo kryo, Output output, ImmutableMap<Object, ? extends Object> immutableMap) {
        this.mapSerializer.write(kryo, output, (Map)Maps.newHashMap(immutableMap));
    }

    public ImmutableMap<Object, Object> read(Kryo kryo, Input input, Class<ImmutableMap<Object, ? extends Object>> type) {
        Class<HashMap> hashMapClass = HashMap.class;
        Map map = this.mapSerializer.read(kryo, input, hashMapClass);
        return ImmutableMap.copyOf((Map)map);
    }

    protected static void registerSerializers(Kryo kryo) {
        ImmutableMapSerializer serializer = new ImmutableMapSerializer((MapSerializer)kryo.getSerializer(Map.class));
        kryo.register(ImmutableMap.class, (Serializer)serializer);
        kryo.register(ImmutableMap.of().getClass(), (Serializer)serializer);
        Object o1 = new Object();
        Object o2 = new Object();
        kryo.register(ImmutableMap.of((Object)o1, (Object)o1).getClass(), (Serializer)serializer);
        kryo.register(ImmutableMap.of((Object)o1, (Object)o1, (Object)o2, (Object)o2).getClass(), (Serializer)serializer);
    }
}

