/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serialize.IntSerializer;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.List;

public class SubListSerializer
extends Serializer {
    private Serializer _serializer;

    public SubListSerializer(Kryo kryo, Class<? extends List<?>> type) {
        if (JavaUtilSubListSerializer.canSerialize(type)) {
            this._serializer = new JavaUtilSubListSerializer(kryo);
        } else if (ArrayListSubListSerializer.canSerialize(type)) {
            this._serializer = new ArrayListSubListSerializer(kryo);
        } else {
            throw new IllegalArgumentException("Unsupported type " + type + ". Check canSerialize(Class) to see if this serializer can handle a given type.");
        }
    }

    private static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean canSerialize(Class<?> type) {
        return JavaUtilSubListSerializer.canSerialize(type) || ArrayListSubListSerializer.canSerialize(type);
    }

    public <T> T readObjectData(ByteBuffer buffer, Class<T> clazz) {
        return (T)this._serializer.readObjectData(buffer, clazz);
    }

    public void writeObjectData(ByteBuffer buffer, Object obj) {
        this._serializer.writeObjectData(buffer, obj);
    }

    static /* synthetic */ Class access$000(String x0) {
        return SubListSerializer.getClass(x0);
    }

    static class ArrayListSubListSerializer
    extends Serializer {
        private static final Class<?> SUBLIST_CLASS = SubListSerializer.access$000("java.util.ArrayList$SubList");
        private final Kryo _kryo;
        private Field _parentField;
        private Field _parentOffsetField;
        private Field _sizeField;

        public ArrayListSubListSerializer(Kryo kryo) {
            this._kryo = kryo;
            try {
                Class<?> clazz = Class.forName("java.util.ArrayList$SubList");
                this._parentField = clazz.getDeclaredField("parent");
                this._parentOffsetField = clazz.getDeclaredField("parentOffset");
                this._sizeField = clazz.getDeclaredField("size");
                this._parentField.setAccessible(true);
                this._parentOffsetField.setAccessible(true);
                this._sizeField.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        static boolean canSerialize(Class<?> type) {
            return SUBLIST_CLASS != null && SUBLIST_CLASS.isAssignableFrom(type);
        }

        public <T> T readObjectData(ByteBuffer buffer, Class<T> clazz) {
            List list = (List)this._kryo.readClassAndObject(buffer);
            int fromIndex = IntSerializer.get((ByteBuffer)buffer, (boolean)true);
            int toIndex = IntSerializer.get((ByteBuffer)buffer, (boolean)true);
            return (T)list.subList(fromIndex, toIndex);
        }

        public void writeObjectData(ByteBuffer buffer, Object obj) {
            try {
                int parentOffset;
                this._kryo.writeClassAndObject(buffer, this._parentField.get(obj));
                int fromIndex = parentOffset = this._parentOffsetField.getInt(obj);
                IntSerializer.put((ByteBuffer)buffer, (int)fromIndex, (boolean)true);
                int toIndex = fromIndex + this._sizeField.getInt(obj);
                IntSerializer.put((ByteBuffer)buffer, (int)toIndex, (boolean)true);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class JavaUtilSubListSerializer
    extends Serializer {
        private static final Class<?> SUBLIST_CLASS = SubListSerializer.access$000("java.util.SubList");
        private final Kryo _kryo;
        private Field _listField;
        private Field _offsetField;
        private Field _sizeField;

        public JavaUtilSubListSerializer(Kryo kryo) {
            this._kryo = kryo;
            try {
                Class<?> clazz = SUBLIST_CLASS;
                this._listField = clazz.getDeclaredField("l");
                this._offsetField = clazz.getDeclaredField("offset");
                this._sizeField = clazz.getDeclaredField("size");
                this._listField.setAccessible(true);
                this._offsetField.setAccessible(true);
                this._sizeField.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        static boolean canSerialize(Class<?> type) {
            return SUBLIST_CLASS != null && SUBLIST_CLASS.isAssignableFrom(type);
        }

        public <T> T readObjectData(ByteBuffer buffer, Class<T> clazz) {
            List list = (List)this._kryo.readClassAndObject(buffer);
            int fromIndex = IntSerializer.get((ByteBuffer)buffer, (boolean)true);
            int toIndex = IntSerializer.get((ByteBuffer)buffer, (boolean)true);
            return (T)list.subList(fromIndex, toIndex);
        }

        public void writeObjectData(ByteBuffer buffer, Object obj) {
            try {
                this._kryo.writeClassAndObject(buffer, this._listField.get(obj));
                int fromIndex = this._offsetField.getInt(obj);
                IntSerializer.put((ByteBuffer)buffer, (int)fromIndex, (boolean)true);
                int toIndex = fromIndex + this._sizeField.getInt(obj);
                IntSerializer.put((ByteBuffer)buffer, (int)toIndex, (boolean)true);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

